﻿using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace TextInputSample;

public class SocialMediaViewModel : INotifyPropertyChanged
{
    private ObservableCollection<ItemModel> items;

    public ObservableCollection<ItemModel> Items
    {
        get { return items; }
        set
        {
            items = value;
            OnPropertyChanged();
        }
    }

    public SocialMediaViewModel()
    {
        InitializeItems();
    }

    private void InitializeItems()
    {
        Items = new ObservableCollection<ItemModel>
        {
            new ItemModel
            {
                ItemName = "Fruits Category",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 1, Name = "Apple" },
                    new OptionModel { Id = 2, Name = "Banana" },
                    new OptionModel { Id = 3, Name = "Orange" },
                    new OptionModel { Id = 4, Name = "Mango" },
                    new OptionModel { Id = 5, Name = "Grapes" }
                }
            },
            new ItemModel
            {
                ItemName = "Vegetables Category",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 6, Name = "Carrot" },
                    new OptionModel { Id = 7, Name = "Broccoli" },
                    new OptionModel { Id = 8, Name = "Tomato" },
                    new OptionModel { Id = 9, Name = "Cucumber" },
                    new OptionModel { Id = 10, Name = "Spinach" }
                }
            },
            new ItemModel
            {
                ItemName = "Dairy Products",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 11, Name = "Milk" },
                    new OptionModel { Id = 12, Name = "Cheese" },
                    new OptionModel { Id = 13, Name = "Yogurt" },
                    new OptionModel { Id = 14, Name = "Butter" },
                    new OptionModel { Id = 15, Name = "Cream" }
                }
            },
            new ItemModel
            {
                ItemName = "Grains & Cereals",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 16, Name = "Rice" },
                    new OptionModel { Id = 17, Name = "Wheat" },
                    new OptionModel { Id = 18, Name = "Corn" },
                    new OptionModel { Id = 19, Name = "Oats" },
                    new OptionModel { Id = 20, Name = "Barley" }
                }
            },
            new ItemModel
            {
                ItemName = "Proteins",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 21, Name = "Chicken" },
                    new OptionModel { Id = 22, Name = "Fish" },
                    new OptionModel { Id = 23, Name = "Beef" },
                    new OptionModel { Id = 24, Name = "Eggs" },
                    new OptionModel { Id = 25, Name = "Tofu" }
                }
            },
            new ItemModel
            {
                ItemName = "Snacks",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 31, Name = "Chips" },
                    new OptionModel { Id = 32, Name = "Cookies" },
                    new OptionModel { Id = 33, Name = "Pretzels" },
                    new OptionModel { Id = 34, Name = "Crackers" },
                    new OptionModel { Id = 35, Name = "Nuts" }
                }
            },
            new ItemModel
            {
                ItemName = "Condiments",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 36, Name = "Ketchup" },
                    new OptionModel { Id = 37, Name = "Mustard" },
                    new OptionModel { Id = 38, Name = "Mayonnaise" },
                    new OptionModel { Id = 39, Name = "Soy Sauce" },
                    new OptionModel { Id = 40, Name = "Hot Sauce" }
                }
            },
            new ItemModel
            {
                ItemName = "Spices",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 41, Name = "Salt" },
                    new OptionModel { Id = 42, Name = "Pepper" },
                    new OptionModel { Id = 43, Name = "Cumin" },
                    new OptionModel { Id = 44, Name = "Paprika" },
                    new OptionModel { Id = 45, Name = "Oregano" }
                }
            },
            new ItemModel
            {
                ItemName = "Baking Goods",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 46, Name = "Flour" },
                    new OptionModel { Id = 47, Name = "Sugar" },
                    new OptionModel { Id = 48, Name = "Baking Soda" },
                    new OptionModel { Id = 49, Name = "Baking Powder" },
                    new OptionModel { Id = 50, Name = "Yeast" }
                }
            },
            new ItemModel
            {
                ItemName = "Frozen Foods",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 51, Name = "Ice Cream" },
                    new OptionModel { Id = 52, Name = "Frozen Pizza" },
                    new OptionModel { Id = 53, Name = "Frozen Vegetables" },
                    new OptionModel { Id = 54, Name = "Frozen Fruits" },
                    new OptionModel { Id = 55, Name = "Frozen Meals" }
                }
            },
            new ItemModel
            {
                ItemName = "Pantry Staples",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 56, Name = "Pasta" },
                    new OptionModel { Id = 57, Name = "Rice" },
                    new OptionModel { Id = 58, Name = "Canned Beans" },
                    new OptionModel { Id = 59, Name = "Canned Tomatoes" },
                    new OptionModel { Id = 60, Name = "Oatmeal" }
                }
            },
            new ItemModel
            {
                ItemName = "Breakfast Items",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 61, Name = "Cereal" },
                    new OptionModel { Id = 62, Name = "Pancake Mix" },
                    new OptionModel { Id = 63, Name = "Syrup" },
                    new OptionModel { Id = 64, Name = "Jam" },
                    new OptionModel { Id = 65, Name = "Peanut Butter" }
                }
            },
            new ItemModel
            {
                ItemName = "Snacks",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 31, Name = "Chips" },
                    new OptionModel { Id = 32, Name = "Cookies" },
                    new OptionModel { Id = 33, Name = "Pretzels" },
                    new OptionModel { Id = 34, Name = "Crackers" },
                    new OptionModel { Id = 35, Name = "Nuts" }
                }
            },
            new ItemModel
            {
                ItemName = "Condiments",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 36, Name = "Ketchup" },
                    new OptionModel { Id = 37, Name = "Mustard" },
                    new OptionModel { Id = 38, Name = "Mayonnaise" },
                    new OptionModel { Id = 39, Name = "Soy Sauce" },
                    new OptionModel { Id = 40, Name = "Hot Sauce" }
                }
            },
            new ItemModel
            {
                ItemName = "Spices",
                IsLastItem = false,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 41, Name = "Salt" },
                    new OptionModel { Id = 42, Name = "Pepper" },
                    new OptionModel { Id = 43, Name = "Cumin" },
                    new OptionModel { Id = 44, Name = "Paprika" },
                    new OptionModel { Id = 45, Name = "Oregano" }
                }
            },
            new ItemModel
            {
                ItemName = "Beverages",
                IsLastItem = true,
                Options = new ObservableCollection<OptionModel>
                {
                    new OptionModel { Id = 26, Name = "Tea" },
                    new OptionModel { Id = 27, Name = "Coffee" },
                    new OptionModel { Id = 28, Name = "Juice" },
                    new OptionModel { Id = 29, Name = "Milk" },
                    new OptionModel { Id = 30, Name = "Water" }
                }
            }
        };
    }

    public event PropertyChangedEventHandler PropertyChanged;

    protected void OnPropertyChanged([CallerMemberName] string propertyName = "")
    {
        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
    }
}

public class ItemModel : INotifyPropertyChanged
{
    private string itemName;
    private object selectedComboItem;

    private string name;
    private bool isLastItem;
    private ObservableCollection<OptionModel> options;

    public string ItemName
    {
        get { return itemName; }
        set
        {
            if (itemName != value)
            {
                itemName = value;
                OnPropertyChanged();
            }
        }
    }

    public string Name
    {
        get { return name; }
        set
        {
            if (name != value)
            {
                name = value;
                OnPropertyChanged();
            }
        }
    }

    public object SelectedComboItem
    {
        get { return selectedComboItem; }
        set
        {
            if (selectedComboItem != value)
            {
                selectedComboItem = value;

                OnPropertyChanged();

            }
        }
    }



    public bool IsLastItem
    {
        get { return isLastItem; }
        set
        {
            if (isLastItem != value)
            {
                isLastItem = value;
                OnPropertyChanged();
            }
        }
    }

    public ObservableCollection<OptionModel> Options
    {
        get { return options; }
        set
        {
            if (options != value)
            {
                options = value;
                OnPropertyChanged();
            }
        }
    }

    public event PropertyChangedEventHandler PropertyChanged;

    protected void OnPropertyChanged([CallerMemberName] string propertyName = "")
    {
        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
    }
}

public class OptionModel
{
    public int Id { get; set; }
    public string Name { get; set; }

    public override string ToString()
    {
        return Name;
    }
}