﻿using Syncfusion.Data;
using Syncfusion.Data.Extensions;
using Syncfusion.UI.Xaml.Grid;
using Syncfusion.UI.Xaml.Grid.Helpers;
using Syncfusion.UI.Xaml.TreeGrid;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace SfTreeGrid_Shift_Peformance
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            treeGrid.SelectionController = new TreeGridSelectionControllerExt(treeGrid);
        }

    }
    public class EmployeeInfo
    {
        int _id;
        string _firstName;
        string _lastName;
        private string _title;
        double? _salary;
        int _reportsTo;

        public string FirstName
        {
            get { return _firstName; }
            set { _firstName = value; }
        }

        public string LastName
        {
            get { return _lastName; }
            set { _lastName = value; }
        }

        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }

        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }

        public double? Salary
        {
            get { return _salary; }
            set { _salary = value; }
        }

        public int ReportsTo
        {
            get { return _reportsTo; }
            set { _reportsTo = value; }
        }
    }

    public class ViewModel
    {

        public ViewModel()
        {
            this.Employees = this.GetEmployees();
            viewSource = new GridVirtualizingCollectionView(Employees);
        }
        private ObservableCollection<EmployeeInfo> _employees;

        public ObservableCollection<EmployeeInfo> Employees
        {
            get { return _employees; }
            set { _employees = value; }
        }


        private VirtualizingCollectionView viewSource;

        public VirtualizingCollectionView ViewSource
        {
            get { return viewSource; }
            set { viewSource = value; }
        }

        private ObservableCollection<EmployeeInfo> GetEmployees()
        {
            ObservableCollection<EmployeeInfo> employeeDetails = new ObservableCollection<EmployeeInfo>();
          
            employeeDetails.Add(new EmployeeInfo() { FirstName = "Ronald", LastName = "Fillmore", Title = "Production", Salary = 2800000, ReportsTo = -1, ID = 8 });
            int id = 8;
            for (int i = 0; i < 100; i++)
            {
                id++;
                employeeDetails.Add(new EmployeeInfo() { FirstName = "Jillian", LastName = "Carson", ID = id, Salary = 600000, ReportsTo = 8, Title = "Production Manager" });
                id++;
                employeeDetails.Add(new EmployeeInfo() { FirstName = "Shu", LastName = "Ito", ID = id, Salary = 550000, ReportsTo = 8, Title = "Production Engineer" });
                id++;
                employeeDetails.Add(new EmployeeInfo() { FirstName = "Stephen", LastName = "Jiang", ID = id, Salary = 450000, ReportsTo = 8, Title = "Production Engineer" });
            }
            return employeeDetails;
        }
    }

    public class TreeGridSelectionControllerExt : TreeGridRowSelectionController
    {
        SfTreeGrid treeGrid;
        public TreeGridSelectionControllerExt(SfTreeGrid TreeGrid) : base(TreeGrid)
        {
            treeGrid = TreeGrid;
        }

        /// <summary>
        /// Processes the row selection when the mouse pointer is released from SfDataGrid. 
        /// </summary>
        /// <param name="args">
        /// Contains the data for mouse pointer action.
        /// </param>
        /// <param name="rowColumnIndex">
        /// The corresponding rowColumnIndex of the mouse released point.
        /// </param>
        /// <remarks>
        /// The selection is initialized in pointer released state when the <see cref="Syncfusion.UI.Xaml.Grid.SfDataGrid.AllowSelectionPointerPressed"/> set as false.        
        /// </remarks>
        protected override void ProcessPointerReleased(MouseButtonEventArgs args, Syncfusion.UI.Xaml.ScrollAxis.RowColumnIndex rowColumnIndex)
        {
            if (SelectionHelper.CheckShiftKeyPressed() && this.PressedRowColumnIndex.RowIndex > 0)
            {
                this.SelectRows(this.PressedRowColumnIndex.RowIndex, rowColumnIndex.RowIndex);
            }
            else
                base.ProcessPointerReleased(args, rowColumnIndex);
        }

        /// <summary>
        /// Selects the rows corresponding to the specified start and end index of the row.
        /// </summary>
        /// <param name="startRowIndex">
        /// The start index of the row.
        /// </param>
        /// <param name="endRowIndex">
        /// The end index of the row.
        /// </param>
        public override void SelectRows(int startRowIndex, int endRowIndex)
        {
            if (startRowIndex < 0 || endRowIndex < 0)
                return;

            if (startRowIndex > endRowIndex)
            {
                var temp = startRowIndex;
                startRowIndex = endRowIndex;
                endRowIndex = temp;
            }

            if (this.treeGrid.SelectionMode == GridSelectionMode.None ||
                this.treeGrid.SelectionMode == GridSelectionMode.Single)
                return;

            var isSelectedRowsContains = this.SelectedRows.Any();

            this.SuspendUpdates();
            var addedItem = new List<object>();
            int rowIndex = startRowIndex;

            this.treeGrid.SelectedItems.Clear();
            var rowIndexes = this.treeGrid.SelectionController.SelectedRows.Select(rowinfo => rowinfo.RowIndex).ToList();

            var selectedrowindex = this.treeGrid.ResolveToRowIndex(this.treeGrid.SelectedIndex);

            string className = "Syncfusion.UI.Xaml.TreeGrid.Helpers.TreeGridSelectionHelper, Syncfusion.SfGrid.WPF";

            Type helperType = Type.GetType(className);

            Type[] parameterTypes = new Type[] { typeof(int) };
            MethodInfo method = (this as TreeGridBaseSelectionController).GetType().GetMethod(
            "GetTreeGridSelectedRow",
            BindingFlags.Instance | BindingFlags.NonPublic,
            null,
            parameterTypes,
            null);

            Type[] HelperParameterTypes = new Type[]
            {
                typeof(SfTreeGrid),
                typeof(int),
                typeof(Syncfusion.UI.Xaml.TreeGrid.TreeNode)
            };

            MethodInfo method1 = helperType.GetMethod(
                "ShowRowSelection",
                BindingFlags.Static | BindingFlags.NonPublic,
                null,
                HelperParameterTypes,
                null
            );
            
            for (int i = rowIndex; i <= endRowIndex; i++)
            {
                object treenode = this.treeGrid.GetNodeAtRowIndex(i);

                if (!rowIndexes.Contains(i))
                {
                    this.SelectedRows.Add((TreeGridRowInfo)method.Invoke(this, new object[] { i }));
                    method1.Invoke(null, new object[] { treeGrid, i, treenode });
                }
                if (treenode != null)
                {
                    this.treeGrid.SelectedItems.Add(treenode);
                }
            }

            if (!isSelectedRowsContains)
            {
                this.treeGrid.SelectedIndex = this.SelectedRows.Count > 0 ? this.treeGrid.ResolveToNodeIndex(this.SelectedRows[0].RowIndex) : -1;
                this.treeGrid.SelectedItem = this.treeGrid.SelectedItems.Count > 0 ? this.treeGrid.SelectedItems[0] : null;

            }
            this.ResumeUpdates();
        }
    }
}
