﻿using System.Diagnostics;
using Syncfusion.Maui.ImageEditor;

namespace SfImageEditorDemo;

public partial class MainPage : ContentPage
{
    public MainPage()
    {
        InitializeComponent();
    }

    protected override void OnAppearing()
    {
        base.OnAppearing();

        var imageBytes = Convert.FromBase64String(ImageSourceData.ImageBytesBase64);

        var imageSource = ImageSource.FromStream(() => new MemoryStream(imageBytes));

        ImageEditor.Source = imageSource;

        ImageEditor.AnnotationSelected += ImageEditorOnAnnotationSelected;
        ImageEditor.ToolbarItemSelected += ImageEditorOnToolbarItemSelected;
    }

    private void ImageEditorOnToolbarItemSelected(object? sender, ToolbarItemSelectedEventArgs e)
    {
        Debug.WriteLine("ToolbarItem selected: " + e.ToolbarItem?.Name);
    }

    private void ImageEditorOnAnnotationSelected(object? sender, AnnotationSelectedEventArgs e)
    {
        Debug.WriteLine("Annotation selected: " + (e.AnnotationSettings?.Id ?? "no id"));
    }
}
