﻿namespace ComboBoxSample
{
    public partial class MainPage : ContentPage
    {

        public MainPage()
        {
            InitializeComponent();
        }

        private void CollectGCClicked(object sender, EventArgs e)
        {
            _ = ReloadMemoryAsync();
        }

        private void OnCounterClicked(object sender, EventArgs e)
        {
            _ = Navigation.PushAsync(new ButtonPage());
        }
        public static bool MemoryLeakPopupWasShown { get; set; }

        protected override void OnAppearing()
        {
            base.OnAppearing();

            _ = ReloadMemoryAsync();
        }

        protected override void OnNavigatedFrom(NavigatedFromEventArgs args)
        {
            base.OnNavigatedFrom(args);

            MemoryLeakPopupWasShown = false;
        }

        private async Task ReloadMemoryAsync()
        {
            LabelMemoryTracker.Text = "Current Memory Usage: Calculating...";

            await Task.Delay(TimeSpan.FromMilliseconds(500));

            GC.Collect();
            GC.WaitForPendingFinalizers();

            var currentMemoryInBytes = GC.GetTotalMemory(true);

            LabelMemoryTracker.Text = $"Current Memory Usage: {ConvertByteCountToKbString(currentMemoryInBytes)}";
        }

        private static string ConvertByteCountToString(long? byteCount)
        {
            if (byteCount == null)
            {
                return "Unknown";
            }

            string[] suf = { " B", " KB", " MB", " GB", " TB", " PB", " EB" }; //Longs run out around EB

            if (byteCount == 0)
            {
                return "0" + suf[0];
            }

            var bytes = Math.Abs(byteCount.Value);
            var place = Convert.ToInt32(Math.Floor(Math.Log(bytes, 1024)));
            var num = Math.Round(bytes / Math.Pow(1024, place), 1);

            return (Math.Sign(byteCount.Value) * num).ToString() + suf[place];
        }

        private static string ConvertByteCountToKbString(long? byteCount)
        {
            if (byteCount == null)
            {
                return "Unknown";
            }

            const long bytesInKb = 1024;

            var kbCount = (double)byteCount.Value / bytesInKb;

            var roundedKbCount = Math.Round(kbCount, 1);

            return $"{roundedKbCount} KB";
        }
    }

}
