﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * All application specific English language help tooltip strings.
 */
public static class Tooltips_EN
{
	// Load static string table
	public static Dictionary<string, string> Load()
	{
		return new Dictionary<string, string>
		{
			/* Shell */

			// Card
			{ "card.link", "A green badge indicates a successful link with one or more user accounts.\n\nAn orange badge indicates an invite has been sent, but the user has not yet created an account." },

			// Form
			{ "form.image", "Optionally select an image, either from your photo album or taken with the camera." },
			{ "form.lock", "This is a sample item and is locked. Changes will not be saved." },

			// Account
			{ "account.role", "Updates the role that indicates how you're using the app. Your role affects which features and data are available.\n\nIf you're trying to access an existing team but don't see it, have the user that created the team grant you access." },
			{ "account.fan", "Use the app as a Fan rather than your normal account level. This allows you to receive live match updates and use the Shot Tracker.\n\nYou can NOT record stats while Fan Mode is On. Fan mode will reset to Off each time you restart the app." },

			/* Settings */

			// Recording
			{ "settings.record.engine", "Should the stat recording interface use the new iStatVball 3 RallyFlow\u2122 system or the Legacy system from iStatVball 2?\n\nThe system can be changed at any time except during a set." },
			{ "settings.record.pass", "Should pass ratings use a 0-3 or 0-4 scale?\n\nThe 0-3 scale is more common, but 0-4 distinguishes an overpass from an error.\n\nIn either case, 0 is an error, and 1,2,3 or 2,3,4 are quality of the pass.\n\nNOTE: The app must be restarted for the change to take effect." },
			{ "settings.record.switch", "When should teams switch sides, between each set or never?\n\nThis setting can be overriden at any time while recording." },
			{ "settings.record.write", "How often should stats be uploaded to the cloud while recording?\n\nNOTE: If you're on a slow/spotty WiFi connection, you should put the device in Airplane Mode so the app knows to run offline.\n\n'Every action' supports real-time Live updates on remote devices but requires a fast network connection.\n\n'End of rally' supports Live updates with a slight delay but performs better on slow connections." },

			// RallyFlow
			{ "settings.rally.level", "Choose the level of detail for recorded stats. With higher levels of detail, stat analysis will become more powerful, but recording stats during fast-paced live matches will be more difficult.\n\nStart with a lower level as you're learning. Then increase the level as you become more comfortable, or if you're recording stats from video.\n\n" +
									  "LOW\nGives you full Team, Rotation, Sideout, and Opponent stats and charts, but there are no Player stats except for serve. Lineups, substitutions, and libero swaps are NOT required.\n\nThis level is extremely easy to use, even for beginners on a fast-paced match. It's a great way to get started, and you can fill-in players later from video if needed.\n\n" +
									  "MEDIUM  (recommended)\nAdds full Player stats while still minimizing required taps. The tradeoff is slightly slower recording speed. Serve/Pass ratings (0-4) are automatic. Selection of the setter on 2nd Ball is also automatic, but can be overriden with a swipe rather than tap.\n\n" +
									  "HIGH\nAdds manual control of Serve/Pass ratings (0-4) as well as Fault modifiers (double, throw, net, etc).\n\n" +
									  "MAXIMUM\nAdds full shot modififiers (jump serve, tip, dump, etc), Set ratings (0-4), and all Block touches. Typically used when recording stats from video.\n\n" +
									  "CUSTOM\nAllows you to start with any of the available levels and then customize individual options as needed." },

			{ "settings.rally.auto", "Should 0-4 ratings be automatically recorded for serves and passes even if ratings flyouts are turned off?\n\nAutomatic ratings are determined by court location. Note that set ratings cannot be automatic." },
			{ "settings.rally.preview", "Should a translucent preview of the current players on the court be shown at the beginning of the set and between rallies?" },

			// Custom Options (RallyFlow)
			{ "settings.custom.quick", "Which stat actions should have QuickSelect enabled? QuickSelect eliminates the need to tap a player for each stat entry.\n\nSet actions automatically select the default setter. Block actions select the player(s) involved in the block only when it ends in a point. All other actions leave the player as anonymous.\n\nYou can override QuickSelect at any time with a quick swipe gesture rather than a tap." },
			{ "settings.custom.rate", "Which stat actions should provide a flyout for specifying a 0-4 rating? All pass actions, as well as sets, are eligible.\n\n0 = error\n1 = overpass/set\n2, 3, 4 = quality rating\n\nNote that pass ratings will have an automatic default value based on pass location.\n\nRatings require that the corresponding QuickSelect option be turned OFF." },
			{ "settings.custom.mod", "Which stat actions should provide a flyout for specifying a more detailed shot type ('tip', 'shot', 'dump' for Attack, etc)?\n\nModifiers require that the corresponding QuickSelect option be turned OFF." },
			{ "settings.custom.fault", "Which stat actions should provide a flyout for specifying more detail when a fault occurs ('foot fault' for Serve, 'throw' for Receive, etc)?" },

			// Player Grid (RallyFlow)
			{ "settings.grid.display", "How should players be displayed in the popup player select grid? Use whichever option allows you to find players the fastest." },
			{ "settings.grid.order", "How should players be arranged in the popup player select grid?\n\nSmart Locations places players where they're most likely to be for each ball contact.\n\nRotation keeps them in their current rotation order on court.\n\nSorted sorts based on display type (first name, number, etc)." },
			{ "settings.grid.title", "Should the player select grid show a title for the current stat action (serve, block, etc)?" },

			// Smart Locations
			{ "settings.smart.libero", "Should the libero default to left-back or middle-back?" },
			{ "settings.smart.ai", "Should the RallyFlow\u2122 AI engine be used to position players in the player grid based on your previous stat recording?\n\nThis feature works best when using pre-created lineups. Its accuracy will improve the more you use the same lineup." },

			// Substitutions
			{ "settings.subs.max", "Maximum number of substitutions per set, or unlimited subs." },
			{ "settings.subs.warn", "Show a warning when only this number of substitutions remain. Select 0 for no warning." },

			// Timeout
			{ "settings.timeout.max", "Maximum number of timeouts allowed per set." },
			{ "settings.timeout.sec", "Duration in seconds of each timeout. Unless turned off, a countdown timer will be displayed during the timeout." },

			// Legacy
			{ "settings.legacy.focus", "Should the Auto Focus feature be enabled? Auto Focus only enables stat buttons that are relevant for each contact in the rally, which can help you find buttons faster." },
			{ "settings.legacy.smart", "As soon as the ball is served, should players move to their physical location on court rather than staying in rotation order?\n\nFor example, the front row outside hitter will move to left-front, the middle to middle-front, the libero to left-back, etc.\n\nThis can make it quicker to find the right player." },
			{ "settings.legacy.set", "Should setter stats be automatically recorded?\n\nChoose whether only Assists, or both Assists and Attempts, will be automatically credited to your (backrow) setter.\n\nIf someone other than the setter sets the ball, tap Attempt (ATT) for that player." },
			{ "settings.legacy.serve", "Should the serve category use Attempt-Ace-Error (ATT-ACE-ERR), or should it use serve ratings (0-4)?\n\nFor serve ratings, 0 is error, 4 is ace or overpass, and 1,2,3 correspond to quality of the opponent pass.\n\nNote that the format cannot be changed during a set." },
			{ "settings.legacy.pass0", "Should a 0-rated pass (error) automatically end the rally? Only applicable for the 0-3 rating scale." },
			{ "settings.legacy.recv", "Should the Passing category buttons be enabled for free ball passing also or only for serve receive?\n\nIf both are on, you will automatically get separate stats for each.\n\nIf only serve receive is on, you will need to use the Undo Auto Assist button on overpasses to maintain accurate setting stats." },

			// Analyze
			{ "settings.analyze.player", "How should players be displayed in all Analyze stat tables?\n\nPlayers can be sorted in ascending or descending order by tapping the column header." },
			{ "settings.analyze.digits", "How many decimal digits (0-3) should be displayed for average and percentage stats?" },
			{ "settings.analyze.scrimmage", "Should scrimmages be included in season stats? This setting can be overriden by using the blue Filter button when analyzing season stats." },

			// Export
			{ "settings.export.email", "How should email exports be sent?\n\nLOCAL: Uses the default email app on the device (Apple/Google Mail). Does not support group send.\n\nCLOUD: Sends via a cloud-based email provider (SendGrid). Supports group send to your players, coaches, etc.\n\nNOTE: If emails are not arriving at their destination, try changing this setting." },
			{ "settings.export.format", "What format should be used for stat report exports?\n\nPDF- Best for display and printing. Supports all stat tables, charts, and graphs.\n\nExcel- Allows stats to be opened in Microsoft Excel, Apple Numbers, etc. Does NOT support charts or graphs." },
			{ "settings.export.maxpreps", "Which system should MaxPreps exports use?\n\nAutomatic upload- Once configured, uploads require only a couple button taps.\n\nManual file export- Stats must be exported, sent via email, then manually uploaded to MaxPreps.\n\nNOTE: If you're experiencing export issues, try changing this setting." },

			// General
			{ "settings.general.sort", "Should the roster and lineup menus be sorted by last name, first name, or jersey number?" },
			{ "settings.general.add", "Should 'Add New' item cards be shown at the start or end of the item list?" },
			{ "settings.general.filter", "Should the match list in Season Home filter out tournament matches or show all matches?" },
			{ "settings.general.sample", "Should the sample organization and its related data be shown in the interface?\n\nIt can be useful if you're new to the app, but feel free to turn it off at any time." },

			/* Launch */

			// Launch
			{ "launch.start", "If you're a new user, tap Create New Account to get started. If you already have an account, tap Use Existing Account." },

			// Create
			{ "create.user", "Enter the email address to be used as your unique username. It's easiest if you have access to the account on this device." },
			{ "create.pswd", "Enter a secure password for your account. It must be at least 8 characters long and should include a combination of letters, numbers, and special characters." },
			{ "create.pswd2", "Enter your password again to make sure you entered it correctly." },

			{ "create.first", "Enter your first name to be used for display purposes within the app." },
			{ "create.last", "Enter your last name to be used for display purposes within the app." },
			{ "create.role", "Enter the primary role in which you will be using the app.\n\nDirector- Allows you to control access to, and aggregate stats for, all the teams in your organization. Great for club directors.\n\nCoach- Allows you to access the full feature set of the app for any team you create or are granted access to.\n\nStatistician- Allows you to help record stats for an existing team. You can manage the roster but cannot analyze stats.\n\nParent/Fan- Allows you to track stats for one player on the team and to use the Live StatTracker.\n\nPlayer- Allows you to analyze all your stats for the season or entire career.\n\nMedia- Allows media members to view the official Box Score report (but nothing else)." },

			// Login
			{ "login.user", "Enter the email address you used as the username when creating your account." },
			{ "login.pswd", "Enter the secure password for your account." },
 
			/* Model */
			
			// Organization
			{ "organization.type", "The type of your organization (Club, High School, College, etc)." },
			{ "organization.name", "The name of your organization ('Springfield High', 'Club Spikers', etc)." },
			{ "organization.abbreviation", "A short 1-5 character abbreviation for your organization name. Used in places where the full name will not fit." },

			{ "organization.mascot", "Optional organization mascot ('Vikings', 'Golden Bears', etc)." },
			{ "organization.location", "Optional location (City, State) where the organization is based." },
			{ "organization.color", "Optional primary uniform color of the organization. Used to customize colors throughout the app interface." },
			{ "organization.notes", "Optional notes about the organization." },

			// Team
			{ "team.gender", "Type of the team (Men's, Women's, Coed, etc)." },
			{ "team.level.club", "Age level of club team (18U, 16U, 14U, etc)." },
			{ "team.level.hs", "High school team level (Varsity, JV, etc)." },
			{ "team.name", "Unique name of the team within the organization ('Varsity', '16-1', '14-Blue' etc)." },
			{ "team.abbreviation", "A short 1-5 character abbreviation for your team name. Defaults to the abbreviation of the organization. Used in places where the full name will not fit." },

			{ "team.league", "Optional league this team plays in ('Sunset League', 'SCVA', etc)." },
			{ "team.division", "Optional division this team plays in within the league ('4A', 'Division III', etc)." },
			{ "team.notes", "Optional notes about the team." },

			{ "team.link.media", "A Media Contact has access to all match Box Scores for this team, but nothing else.\n\nEnter the email address used to create their account. Use commas to separate multiple users.\n\nAn orange badge indicates a user has been invited but has not yet created an account.\n\nA green badge indicates all users are fully linked and ready to go!" },

			// Season
			{ "season.start", "Approximate starting date of the season." },
			{ "season.end", "Approximate ending date of the season." },
			{ "season.name", "Unique name of the season within the parent team ('Fall 2019', '2019-2020', etc)." },

			{ "season.desc", "Optional longer description of the season." },
			{ "season.result", "Optional final result for the season ('League Champions', '2nd Place State', etc)." },
			{ "season.notes", "Optional notes about the season." },

			// Player
			{ "player.first", "First name of the player." },
			{ "player.last", "Last name of the player." },
			{ "player.number", "Jersey number of the player. Should be unique on the roster. Leading zeroes are allowed." },
			{ "player.deactive", "Is the player currently deactivated on the roster? If a player leaves the team mid-season, they can be deactivated.\n\nDeactivated players are not shown in lineup and substitution lists. Deactivation should occur before starting a match." },

			{ "player.alt", "Optional alternate jersey number for the player. Leading zeroes are allowed. Typically used for liberos." },
			{ "player.positions", "Optional position(s) of the player (Setter, Libero, etc). Required for creating lineups and for stats analysis by position." },
			{ "player.nickname", "Optional nickname for the player." },
			{ "player.height", "Optional height of the player." },
			{ "player.year", "Optional year in school of the player (Freshman, Senior, etc)." },
			{ "player.notes", "Optional notes about the player." },

			{ "player.link", "A linked Player account can analyze stats for the associated player, but noone else. The Player account cannot record stats.\n\nEnter the email address used to create their account.\n\nAn orange badge indicates the user has been invited but has not yet created an account.\n\nA green badge indicates they are fully linked and ready to go!" },
			{ "player.link.fans", "A linked Fan account can follow matches in real-time with live stats and ShotTracker. They can also analyze stats for the associated player.\n\nEnter the email address used to create their account. Use commas to separate multiple users.\n\nAn orange badge indicates a user has been invited but has not yet created an account.\n\nA green badge indicates they are fully linked and ready to go!" },

			// Lineup
			{ "lineup.name", "Descriptive name for the lineup ('Jane setting, Jill libero', '6-2 with John & Jack', etc)." },
			{ "lineup.desc", "Optional longer description for the lineup." },
			{ "lineup.notes", "Optional additional notes about the lineup." },

			{ "lineup.builder.starter", "Tap each rotation 1-6 to select a starting player for that rotation.\n\nYou must also choose the position for each player.\n\nYou can optionally also select 1 or 2 liberos." },
			{ "lineup.builder.sub", "Tap a rotation to choose a player to be substituted out during that rotation.\n\nThen choose the player that will be replacing them.\n\nYou can also specify the position of the incoming player.\n\nUp to 2 players can be substituted per rotation.\n\nAlso choose whether you would like to be asked for confirmation before the substitution occurs.\n\nIf the specified player is not on court at the time of the substitution, the sub will be ignored." },
			{ "lineup.builder.swapin", "Tap a rotation to choose a player to be swapped out for the libero during that rotation.\n\nThen choose the libero that will be replacing them.\n\nLiberos will be automatically swapped out when they reach the front row.\n\nUp to 2 libero swaps can occur per rotation.\n\nAlso choose whether you would like to be asked for confirmation before the swap occurs.\n\nFinally, specify whether the swap should occur at the start or end of the possession." },
			 
			// Coach
			{ "coach.type", "The type of coach (Head Coach, Assistant Coach, etc)." },
			{ "coach.first", "First name of the coach." },
			{ "coach.last", "Last name of the coach." },

			{ "coach.nickname", "Optional nickname for the coach." },
			{ "coach.notes", "Optional notes about this coach." },

			{ "coach.link", "A linked Coach account has full access to this team. Typically used for granting access to assistant coaches. You do NOT need to grant access to the Coach (or Director) that created the team.\n\nEnter the email address used to create their account.\n\nAn orange badge indicates the user has been invited but has not yet created an account.\n\nA green badge indicates they are fully linked and ready to go!" },

			// Statistician
			{ "statistician.type", "The type of statistician (Coach, Parent, Volunteer, etc)." },
			{ "statistician.first", "First name of the statistician." },
			{ "statistician.last", "Last name of the statistician." },

			{ "statistician.nickname", "Optional nickname for the statistician." },
			{ "statistician.notes", "Optional notes about this statistician." },

			{ "statistician.link", "A linked Statistician account can record stats for this team but can not analyze them. Great for parents or other volunteers helping with stats.\n\nEnter the email address used to create their account.\n\nAn orange badge indicates the user has been invited but has not yet created an account.\n\nA green badge indicates they are fully linked and ready to go!" },

			// Opponent
			{ "opponent.org", "Name of the opponent school or club ('Springfield High', 'Club Spikers', etc)." },
			{ "opponent.team", "Name of the opponent team within the organization ('Varsity', '14U', etc)." },
			{ "opponent.abbrev", "A short 1-5 character abbreviation for the opponent. Used in places where the full name will not fit." },

			{ "opponent.mascot", "Optional opponent mascot ('Vikings', 'Golden Bears', etc)." },
			{ "opponent.location", "Optional location (City, State) where the opponent is based." },
			{ "opponent.color", "Optional primary uniform color of the opponent. Used to customize display of the opponent throughout the app." },
			{ "opponent.notes", "Optional notes about the opponent." },

			// Venue
			{ "venue.name", "Name of the venue (gym, school, etc) where matches are held." },

			{ "venue.desc", "Optional longer description for the venue." },
			{ "venue.location", "Optional location (City, State) where this venue is located." },
			{ "venue.notes", "Optional notes about the venue." },

			{ "venue.court.type", "Optionally specify the court material type as Default (red and blue), Wood, or custom Colored Tiles. Line and court colors can be customized." },
			{ "venue.court.line", "Optionally specify the color of the court boundary lines." },
			{ "venue.court.inner", "For colored tile courts, optionally specify the color inside the boundary lines." },
			{ "venue.court.outer", "For colored tile courts, optionally specify the color outside the boundary lines." },

			// Tournament
			{ "tournament.name", "Short name of the tournament ('Winter Classic', 'Junior Nationals', etc)." },
			{ "tournament.desc", "A more detailed description of the tournament." },

			{ "tournament.venue", "Optional venue (gym, school, etc) where the tournament takes place. Venues must be pre-created from Season Home." },
			{ "tournament.result", "Optional final result for the tournament ('1st Place', 'Silver Medal', etc)." },
			{ "tournament.division", "Optional division name or number within the tournament ('Division 2', 'Open', etc)." },
			{ "tournament.seed", "Optional numeric starting seed within the division." },
			{ "tournament.notes", "Optional notes about the tournament." },

			// Match
			{ "match.record", "LIVE: Stats are being recorded live as they happen.\n\nFUTURE MATCH: The match is being setup to record stats at a later time.\n\nFROM PAPER: Stats are being transferred from tally-style paper stats.\n\nFROM VIDEO: Stats are being recorded from video for a match in the past.\n\nUSING RALLYSYNC: Stats are being recorded and synchronized to video using the RallySync tool." },
			{ "match.video", "Contains all video settings for the match. You only need to modify these settings if you're syncing stats to video." },
			{ "match.sets", "How many sets were actually played in the match?" },

			{ "match.date", "Calendar date on which this match takes place. Will default to the current date for live matches." },
			{ "match.time", "Starting time for the match. Will default to the current time for live matches." },
			{ "match.anon", "Are stats for the opposing team attributed to a specific Opponent or are they recorded anonymously? Opponents must be pre-created from Season Home." },
			{ "match.opp", "The opposing team for this match. The Opponent must be pre-created from Season Home." },

			{ "match.tourn", "Optionally indicate that this match is part of a tournament. The tournament must be pre-created from Season Home." },
			{ "match.type", "Optionally indicate the type of match (Regular Season, Playoffs, Scrimmage, etc). Can be used to filter stat reports." },
			{ "match.format", "Optionally indicate the score format for the match. Can be used to filter stat reports. NOT required for stat recording." },
			{ "match.league", "Optionally indicate whether or not this is a league match. Can be used to filter stat reports." },
			{ "match.home", "Optionally indicate whether this is a Home or Away match. Can be used to filter stat reports." },
			{ "match.stat", "Optional statistician taking stats for the match. Statisticians must be pre-created from Season Home." },
			{ "match.venue", "Optional venue (gym, school, etc) where the match takes place. Venues must be pre-created from Season Home." },

			{ "match.attend", "Optional spectator attendance number for the match. Used on official Box Score report." },
			{ "match.ref1", "Optional name of first (up) referee for the match. Used on official Box Score report." },
			{ "match.ref2", "Optional name of second (down) referee for the match. Used on official Box Score report." },
			{ "match.notes", "Optional notes about the match." },

			{ "match.resume", "Resume this match after it has been ended? Allows additional sets to be recorded." },

			// Set
			{ "set.serve", "Is this team serving first in the set? You can change the serving team at any time on the recording screen." },
			{ "set.side", "Is this team starting on the left or right side of the court when holding the device in landscape/horizontal orientation?\n\nThis is the same as the top or bottom side of the court in portrait/vertical orientation.\n\nIt helps to hold the device in the same orientation as where you're positioned along the court.\n\nYou can change sides at any time on the recording screen." },
			{ "set.type", "Pre-Created Lineup: Use a lineup already created from Season Home.\n\nBlank Lineup: Start with a new, blank lineup.\n\nTap the eye icon to preview your selected lineup or to review the lineup used for a completed set." },
			{ "set.lineup", "Pre-created lineup to be used for this team for this set." },
			{ "set.rotation", "Optionally specify the starting rotation for this team for this set. Rotation can be changed at any time on the recording screen." },
			{ "set.points", "Optionally specify the starting score for a new set, or edit the score of an existing set." },
			{ "set.notes", "Optional notes about this team for this set." },

			/* Analyze */

			// Trend Graph
			{ "trend.help", "Shows trends for the [] stat over the scope of time being analyzed.\n\nEach player, as well as the team, will have a line on the graph with a data point for each match or set in scope.\n\nTap the legend icon to match players to line colors.\n\nTap and hold on the graph to show data values for each line.\n\nUse the report filter to isolate the team or individual players." },

			// Custom
			{ "custom.name", "Name of your custom analysis dashboard. Should be unique among your dashboards." },
			{ "custom.desc", "Detailed description of your custom dashboard. Should indicate the overall meaning of the included reports and why they are grouped together." },

			{ "custom.team", "Choose whether this report should analyze stats for your team or the opponent." },
			{ "custom.category", "Choose the statistic category for this report (Serving, Hitting, etc).\n\nSome categories are not available for opponent stats." },
			{ "custom.dimension", "Choose whether this report should analyze By Player or By Rotation.\n\nSome categories may support only one or the other. Opponent only supports By Rotation." },
			{ "custom.type", "Choose the type of data visualization for this report (Table, Bar Graph, Shot Chart, etc).\n\nNot all types are available for all categories." },
			{ "custom.stat", "Choose the statistic to be calculated for this report (Hitting Efficiency, Serve Percentage, etc).\n\nNot all statistics are available for all report types." },
			{ "custom.card", "Should the statistic from this report be shown on the dashboard card?\n\nA maximum of 3 stats can be shown at a time." },

			/* Video */

			// Match
			{ "video.sync", "Do you want to sync stats to your match video? This allows you and your players to jump directly to specific serves, attacks, errors, etc." },
			{ "video.host", "Where is the match video hosted? Both YouTube and Vimeo are supported." },
			{ "video.fileid", "Enter the unique identifier of the video. You only need the numeric portion, not the full URL.\n\nYouTube- The ID should look something like: uUonCw2QkMg\n\nVimeo- The ID should look something like: 466580077\n\nNOTE: The video privacy must be set to Public." },
			{ "video.share", "Allow players (and their fans) to view the video and filter to see their ball contacts?" },
			
			// Set
			{ "video.offset", "Elapsed video time (min:sec) to the first serve of the set. Use the exact time at which contact is made for the serve." }
		};
	}
}
