﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * All application specific English language resource strings.
 */
public static class Strings_EN
{
	// Load static string table
	public static Dictionary<string, string> Load()
	{
		return new Dictionary<string, string>
		{
			/* General */

			// Alert
			{ "alert.ok", "OK" },
			{ "alert.cancel", "Cancel" },
			{ "alert.start", "Start" },
			{ "alert.end", "End" },
			{ "alert.error", "Error" },
			{ "alert.error.prefix", "[] Error" },
			{ "alert.warn", "Warning" },
			{ "alert.load", "Loading..." },
			{ "alert.login", "Login" },
			{ "alert.continue", "Continue" },

			// Network
			{ "net.err.req", "Network Required" },
			{ "net.err.base", "A network connection is required to []. Please check your connection and try again." },

			{ "net.err.account", "login or create accounts" },
			{ "net.err.form", "save [] level changes" },
			{ "net.err.delete", "delete data" },
			{ "net.err.help", "play help tutorial videos" },
			{ "net.err.import", "import data" },
			{ "net.err.export", "export stats data" },
			{ "net.err.image", "edit images" },
			{ "net.err.root", "link career stats" },
			{ "net.err.career", "analyze career stats" },
			{ "net.err.home", "access Season Home" },
			{ "net.err.edit", "edit stats" },
			{ "net.err.opponent", "change opponents" },
			{ "net.err.sync", "sync data" },
			{ "net.err.season", "create a new season" },
			{ "net.err.email", "email stat reports" },
			{ "net.err.log", "email Play-by-Play logs" },
			{ "net.err.maxpreps", "upload to MaxPreps" },

			{ "net.err", "Network" },
			{ "net.err.idle", "The app appears to have lost connectivity while idle for a long period of time. Please force quit and restart the app." },
			{ "net.err.write", "An error occurred saving stats. If the problem continues, please reboot the device and contact customer support." },
			{ "net.err.update", "An error occurred updating data. If the problem continues, please contact customer support." },
			
			/* Launch */

			// Landing
			{ "launch.title", "Welcome to" },
			{ "launch.info", "How would you like to get started?" },
			{ "launch.create", "Create New Account" },
			{ "launch.login", "Use Existing Account" },

			// Create
			{ "create.title", "Create Account" },
			{ "create.legal", "By tapping 'Create Account', you agree to the" },
			{ "create.terms", "Terms" },
			{ "create.and", "and" },
			{ "create.privacy", "Privacy Policy" },

			{ "create.username", "Email" },
			{ "create.password", "Password" },
			{ "create.password2", "Password again" },
			{ "create.first", "First name" },
			{ "create.last", "Last name" },
			{ "create.role", "Role" },

			{ "create.success", "Congratulations, your account has been created! Please tap the link in the confirmation email then Sign In to begin." },

			{ "create.err", "Account" },
			{ "create.err.exists", "The account '[]' already exists. Please sign-in with that account or try a different username." },
			{ "create.err.timeout", "Unable to connect to the network. Please check your connection and try again." },
			{ "create.err.unknown", "An unknown error occurred. Please check your connection and try again. ([])" },

			// Login
			{ "login.title", "Sign In" },
			{ "login.forgot", "Forgot Password?" },
			{ "login.retry", "Retry" },
			{ "login.resend", "Resend" },

			{ "login.email", "Email" },
			{ "login.username", "Username" },
			{ "login.password", "Password" },

			{ "login.verify", "A verification email was resent to '[]'. Please check your inbox or spam folder, then tap the verification link in the email." },

			{ "login.err", "Sign In" },
			{ "login.err.empty", "Please enter a valid email address and password." },
			{ "login.err.invalid", "Either the account does not exist or the password is incorrect. Please try again." },
			{ "login.err.verify", "Email address '[]' has not been verified yet. Please check your inbox or spam folder for the email." },

			{ "login.err.timeout", "Unable to connect to the network. Please check your connection and try again." },
			{ "login.err.unknown", "An unknown error occurred. Please check your network connection and try again. ([])" },
			{ "login.err.sync", "There was an error synchronizing your cloud data. Please try again." },

			{ "login.reset.title", "Reset Password" },
			{ "login.reset.msg", "An email with instructions for resetting your password has been sent to the address you provided." },
			{ "login.reset.err", "To reset your password, enter your email address then tap 'Forgot Password?'" },
			{ "login.reset.err.invalid", "That account does not exist. Please try again or create a new account." },
			
			{ "login.sync", "Syncing data..." },

			// Welcome
			{ "welcome.help", "Welcome" },
			{ "welcome.help.coach", "Welcome to iStatVball 3. To get started, we recommend watching some tutorial videos in the Help menu. Then let us know if you have any questions!" },
			{ "welcome.help.other", "Welcome to iStatVball 3! If you don't see your team, ask the head coach to grant you access. To get started, we recommend watching some tutorials in the Help menu." },

			{ "welcome.engine", "Did You Know?" },
			{ "welcome.engine.msg", "iStatVball 3 includes both the new RallyFlow system as well as the 'Legacy' system from iStatVball 2. You can switch at any time under Settings." },

			// Email
			{ "email.address", "support@istatvball.com" },
			{ "email.name", "iStatVball Support" },

			// Invite
			{ "invite.sent", "Invitation Sent" },
			{ "invite.sent.msg", "A [] invitation was successfully sent to '{}'." },

			// Link
			{ "link.success", "Link Success" },
			{ "link.success.msg", "Congratulations, you have successfully granted [] access to '{}'." },
			
			// Billing
			{ "billing.err", "Payment" },
			{ "billing.err.network", "Payment services require an active network connection. Please check your connection and try again." },
			{ "billing.err.connect", "Unable to connect to payment services. Please check your network connection and try again." },
			{ "billing.err.available", "Payment services are not currently available. Please try again in a little while." },
			{ "billing.err.product", "Unable to retrieve product list." },
			{ "billing.err.purchase", "An error occurred while trying to complete the purchase. Please try again." },
			{ "billing.err.payment", "An error occurred processing payment. Please make sure your account has access to in-app purchases and that your payment info is up-to-date." },
			{ "billing.err.pending", "Your payment is currently pending. You will have access as soon as the payment clears." },
			{ "billing.err.cancel", "The payment task was cancelled." },
			{ "billing.err.unknown", "An unknown error occurred accessing payment services. Please contact customer support at support@istatvball.com." },

			/* Review */

			// Prompt
			{ "review.title", "Are you enjoying iStatVball 3?" },
			{ "review.positive", "Yes, love it!" },
			{ "review.negative", "Not so much" },
			{ "review.later", "Ask me later" },

			// Feedback
			{ "review.msg", "Please let us know how we can improve..." },
			{ "review.from", "From" },
			{ "review.feedback", "Feedback" },
			{ "review.enter", "Enter feedback..." },
			{ "review.send", "Send" },

			{ "review.success", "Thank you for your feedback. We will review it and respond as soon as possible." },
			{ "review.err", "An unknown error occurred sending feedback, please try again." },

			/* Shell */

			// Card
			{ "card.new", "Add New" },
			{ "card.analyze", "Analyze" },
			{ "card.edit", "Edit" },
			{ "card.no", "No" },
			{ "card.empty", "No [] Yet" },

			// Form
			{ "form.empty", " " },

			{ "form.new", "New" },
			{ "form.required", "Required" },
			{ "form.optional", "Optional" },
			{ "form.asterisk", "*" },
			{ "form.links", "Account Links" },

			{ "form.cancel", "Cancel" },
			{ "form.save", "Save" },
			{ "form.delete", "Delete" },
			{ "form.discard", "Discard" },
			{ "form.done", "Done" },

			{ "form.delete.msg", "Type DELETE in all caps below to confirm deletion of this []. Deleted data can NOT be restored." },
			{ "form.cancel.title", "Discard Changes" },
			{ "form.cancel.msg", "Are you sure you want to cancel? Any unsaved changes will be discarded." },

			{ "form.category", "Category" },
			{ "form.type", "Type" },
			{ "form.name", "Name" },
			{ "form.abbrev", "Abbreviation" },
			{ "form.desc", "Description" },
			{ "form.notes", "Notes" },
			{ "form.location", "Location" },

			{ "form.hint.required", "[] is a required field" },
			{ "form.hint.multi.min", "[] must have at least 1 value selected" },
			{ "form.hint.multi.max", "[] can have at most {} values selected" },
			{ "form.hint.character", "character" },
			{ "form.hint.characters", "characters" },
			{ "form.hint.digit", "digit" },
			{ "form.hint.digits", "digits" },
			{ "form.hint.text.minimum", "[] must be mininum {} " },
			{ "form.hint.text.range", "[] must be {}-() " },
			{ "form.hint.int.minimum", "[] must be greater than {}" },
			{ "form.hint.int.range", "[] must be between {} and ()" },
			{ "form.hint.email", "Please enter a valid email address" },
			{ "form.hint.emails", "Please enter valid email address(es)" },
			{ "form.hint.url", "Please enter a valid URL" },
			{ "form.hint.pswd", "Both password entries must match" },
			{ "form.hint.date", "End date must be after start date" },
			{ "form.hint.duration", "Choose a time offset" },
			{ "form.hint.video", "Please enter a valid Video ID" },

			{ "form.image", "Tap image to edit" },
			{ "form.image.edit", "Edit Photo" },
			
			{ "form.image.choose", "Choose Photo" },
			{ "form.image.take", "Take Photo" },
			{ "form.image.clear", "Clear Photo" },

			{ "form.image.err.choose", "The app does not not have permission to access the photo library. Please turn on permission in your device Settings." },
			{ "form.image.err.take", "The app does not not have permission to access the camera. Please turn on permission in your device Settings." },

			{ "form.time.hour", "h" },
			{ "form.time.min", "m" },
			{ "form.time.sec", "s" },

			{ "form.tree.all", "All" },
			{ "form.color", "Choose Color" },
			{ "form.text", "Enter text..." },

			{ "form.err.unique", "The [] name must be unique within the parent {}." },

			/* Toolbar */

			{ "toolbar.settings", "Settings" },
			{ "toolbar.help", "Help" },
			{ "toolbar.account", "Account" },
 
			// Settings
			{ "settings.title", "Settings" },
			{ "settings.about", "About iStatVball 3" },
			{ "settings.version", "Version" },

			{ "settings.node", "Your Team" },
			{ "settings.node.opp", "Opponent" },

			// About
			{ "about.credits", "Product Design\nBarry Sohl" },
			{ "about.legal", "Copyright \u00A92009-2025 DemiVision, LLC. All Rights Reserved. 'iStatVball' and 'RallyFlow' are trademarks of DemiVision, LLC. Patent Pending." },
			{ "about.thanks", "Special thanks to all our users and testers that make this app possible." }, 

			// Help
			{ "help.title", "Help" },
			{ "help.subtitle", "Video Tutorials" },

			{ "help.contact", "Contact us" },
			{ "help.subscribe", "Subscribe to newsletter" },
			{ "help.web", "www.istatvball.com" },

			{ "help.log", "Send troubleshooting" },
			{ "help.log.subject", "Troubleshooting Log" },
			{ "help.log.success", "Troubleshooting log successfully sent." },

			{ "help.facebook", "Facebook" },
			{ "help.youtube", "YouTube" },

			{ "help.err", "An error occurred sending the email, please try again." },
			{ "help.err.email", "Your device is not currently configured to send email. Please check your device settings." },

			// Account
			{ "account.title", "Account" },
			{ "account.update", "Update" },
			{ "account.fan", "Fan Mode" },

			{ "account.logout", "Sign Out" },
			{ "account.logout.msg", "Are you sure you want to sign out from your account?" },
			{ "account.logout.err", "An error occurred while signing out. Please try again." },

			{ "account.delete", "Delete Account" },
			{ "account.delete.lbl", "User Account" },
			{ "account.delete.msg", "Permanently delete this account including ALL associated user, organization, stats, and login data?" },
			{ "account.delete.success", "Account successfully deleted. Please note that it may take up to 24 hours for all associated data to be fully deleted." },

			{ "account.terms", "Terms of use" },
			{ "account.privacy", "Privacy policy" },

			// Account-Purchase
			{ "purchase.title", "Purchase" },
			{ "purchase.units", "Team-Seasons" },
			{ "purchase.purchased", "Purchased" },
			{ "purchase.used", "Used" },
			{ "purchase.remaining", "Remaining" },
			{ "purchase.discount", "% OFF" },

			{ "purchase.trial", "Free Trial" },
			{ "purchase.trial.msg", "Your 14 day Free Trial will start as soon as you create your first season. You can purchase Team-Seasons at any time in the Account drawer." },

			{ "purchase.limit", "Trial Limit" },
			{ "purchase.limit.msg", "You can create one season for one team on the Free Trial. You will need to purchase a Team-Season to create another season." },

			{ "purchase.end", "Trial Ended" },
			{ "purchase.end.msg", "Your Free Trial has ended. We hope you enjoyed the evaluation. You will need to purchase a Team-Season to create a new season." },
			{ "purchase.end.msg2", "Your Free Trial has ended. We hope you enjoyed the evaluation. You will need to purchase a Team-Season to continue recording stats." },

			{ "purchase.empty", "No Team-Seasons" },
			{ "purchase.empty.msg", "You have used all of your purchased Team-Seasons. You will need to make a new purchase to create a season." },

			{ "purchase.detail1", "A Team-Season is one season for one team. Team-Seasons can be used for any team, in any organization, in your account." },
			{ "purchase.detail2", "A Team-Season is considered used once at least one match has been recorded within the season. A season cannot extend beyond one year." },

			{ "purchase.success", "Purchase Complete" },
			{ "purchase.success.msg", "Congratulations, your purchase was successfully completed! []" },
			{ "purchase.success.1", "1 Team-Season has been added to your account." },
			{ "purchase.success.N", "[] Team-Seasons have been added to your account." },

			{ "purchase.err.product", "An error occurred retrieving product information." },
			{ "purchase.err.season", "No Free Trial or valid purchase found for this season. Please contact customer support." },
			{ "purchase.err.year", "A purchased Team-Season cannot last for longer that one full year." },

			/* Settings */

			// Recording
			{ "settings.record", "Recording" },

			{ "settings.record.engine", "Stat system" },
			{ "settings.record.engine.0", "rally|RallyFlow\u2122 (v3)" },
			{ "settings.record.engine.1", "legacy|Legacy (v2)" },

			{ "settings.record.pass", "Passing" },
			{ "settings.record.pass.0", "pass03|0-3 Rating" },
			{ "settings.record.pass.1", "pass04|0-4 Rating" },

			{ "settings.record.switch", "Switch sides" },
			{ "settings.record.switch.0", "sets|Between sets" },
			{ "settings.record.switch.1", "never|Never" },

			{ "settings.record.write", "Cloud updates" },
			{ "settings.record.write.0", "action|Every action" },
			{ "settings.record.write.1", "rally|End of rally" },

			// RallyFlow
			{ "settings.rally", "RallyFlow\u2122" },

			{ "settings.rally.level", "Detail level" },
			{ "settings.rally.level.err", "The RallyFlow detail level cannot be changed during a rally unless a lineup is defined." },

			{ "settings.rally.level.0", "low|Low" },
			{ "settings.rally.level.1", "med|Medium" },
			{ "settings.rally.level.2", "high|High" },
			{ "settings.rally.level.3", "max|Maximum" },
			{ "settings.rally.level.4", "custom|Custom" },

			{ "settings.rally.auto", "Use auto ratings" },
			{ "settings.rally.preview", "Show lineup preview" },

			// Custom Options (RallyFlow)
			{ "settings.custom", "Custom Options" },
			{ "settings.custom.quick", "QuickSelect" },
			{ "settings.custom.rate", "Ratings" },
			{ "settings.custom.mod", "Modifiers" },
			{ "settings.custom.fault", "Faults" },

			// Player Grid (RallyFlow)
			{ "settings.grid", "Player Grid" },

			{ "settings.grid.display", "Display" },
			{ "settings.grid.display.0", "first|First name" },
			{ "settings.grid.display.1", "last|Last name" },
			{ "settings.grid.display.2", "nickname|Nickname" },
			{ "settings.grid.display.3", "number|Jersey number" },
			{ "settings.grid.display.4", "photo|Photo" },

			{ "settings.grid.order", "Ordering" },
			{ "settings.grid.order.0", "smart|Smart Locations" },
			{ "settings.grid.order.1", "rot|Rotation" },
			{ "settings.grid.order.2", "sort|Sorted" },

			{ "settings.grid.title", "Show title" },

			// Legacy
			{ "settings.legacy", "Legacy" },

			{ "settings.legacy.focus", "Auto focus" },
			{ "settings.legacy.smart", "Smart locations" },

			{ "settings.legacy.set", "Auto set" },
			{ "settings.legacy.set.0", "full|Assists + Attempts" },
			{ "settings.legacy.set.1", "semi|Assists" },
			{ "settings.legacy.set.2", "off|OFF" },

			{ "settings.legacy.serve", "Serve format" },
			{ "settings.legacy.serve.0", "aae|ATT-ACE-ERR" },
			{ "settings.legacy.serve.1", "04|0-4 Rating" },

			{ "settings.legacy.pass0", "Pass-0 ends rally" },
			{ "settings.legacy.recv", "Pass on receive only" },

			// Smart Locations
			{ "settings.smart", "Smart Locations" },

			{ "settings.smart.libero", "Libero" },
			{ "settings.smart.libero.0", "left|Left-Back" },
			{ "settings.smart.libero.1", "middle|Middle-Back" },

			{ "settings.smart.ai", "Enable AI" },

			// Substitutions
			{ "settings.subs", "Substitutions" },

			{ "settings.subs.max", "Maximum" },
			{ "settings.subs.max.0", "6|6" },
			{ "settings.subs.max.1", "12|12" },
			{ "settings.subs.max.2", "15|15" },
			{ "settings.subs.max.3", "18|18" },
			{ "settings.subs.max.4", "0|Unlimited" },

			{ "settings.subs.warn", "Warning" },

			// Timeout
			{ "settings.timeout", "Timeouts" },

			{ "settings.timeout.max", "Maximum" },

			{ "settings.timeout.sec", "Seconds" },
			{ "settings.timeout.sec.0", "75|75" },
			{ "settings.timeout.sec.1", "60|60" },
			{ "settings.timeout.sec.2", "30|30" },
			{ "settings.timeout.sec.3", "0|OFF" },

			// Analyze
			{ "settings.analyze", "Analyze" },

			{ "settings.analyze.player", "Player display" },
			{ "settings.analyze.player.0", "firstlast|First Last" },
			{ "settings.analyze.player.1", "lastfirst|Last, First" },
			{ "settings.analyze.player.2", "numname|# First Last" },

			{ "settings.analyze.digits", "Decimal digits" },
			{ "settings.analyze.scrimmage", "Include scrimmages" },

			// Export
			{ "settings.export", "Export" },

			{ "settings.export.email", "Email mode" },
			{ "settings.export.email.0", "local|Local" },
			{ "settings.export.email.1", "cloud|Cloud" },

			{ "settings.export.format", "File format" },
			{ "settings.export.format.0", "pdf|PDF" },
			{ "settings.export.format.1", "excel|Excel" },

			{ "settings.export.maxpreps", "MaxPreps" },
			{ "settings.export.maxpreps.0", "auto|Automatic upload" },
			{ "settings.export.maxpreps.1", "file|Manual file export" },

			// General
			{ "settings.general", "General" },

			{ "settings.general.sort", "Roster order" },
			{ "settings.general.sort.0", "last|Last Name" },
			{ "settings.general.sort.1", "first|First Name" },
			{ "settings.general.sort.2", "number|Jersey Number" },

			{ "settings.general.add", "'Add New' cards" },
			{ "settings.general.add.0", "start|Start of list" },
			{ "settings.general.add.1", "end|End of list" },

			{ "settings.general.filter", "Filter tournaments" },
			{ "settings.general.sample", "Sample organization" },

			/* Help */

			// Root
			{ "help.0", "start|Getting started" },
			{ "help.1", "manage|Managing your team" },
			{ "help.2", "match|Match life cycle" },
			{ "help.3", "rally|RallyFlow\u2122 recording" },
			{ "help.4", "legacy|Legacy recording" },
			{ "help.5", "analyze|Analyzing stats" },
			{ "help.6", "export|Exporting stats" },
			{ "help.7", "raw|Raw stats" },

			// Start
			{ "help.start.0", "welcome|Welcome|0:34|394288977|c41534489b732982de1b8dd3b9df20d8ebf41c20" },
			{ "help.start.1", "nav|Navigating the app|2:32|394310174|55cef233e41037ebe25460729e030a0c450b5665" },

			// Manage
			{ "help.manage.0", "org|Organizations|1:06|395073404|d4230732cc310ef590c3481f8c27b9fef612e914" },
			{ "help.manage.1", "team|Teams and seasons|2:08|395073434|ca362c05e9250662f60621e07cabe25e99a508d1" },
			{ "help.manage.2", "home|Season home|2:23|395073416|393d4e6bcf0c4f77b3dfe1333391ba2b147c0dfb" },
			{ "help.manage.3", "roster|Roster|1:37|395073407|a810f0c87e13e5cdbe576714a211c0d16045f7a1" },
			{ "help.manage.4", "lineup|Lineups|1:34|395073385|2c25d20275c63e3be0c78b94970f959b93b1d9e5" },
			{ "help.manage.5", "subswap|Auto subs and swaps|7:37|679369864|1eb3dc5c37f39b8e6d5e60af1832fac6b5dfde43a8a7957f2c895ba3e18ef003" },
			{ "help.manage.6", "import|Importing data|2:30|441495026|3cc98e43c3732421a9730f3ea5c79fe20d6a9a28" },
			{ "help.manage.7", "new|Starting a new season|1:54|585584988|c74b7ce7dade0017f1610e6b4fbe1c57df5e3b46" },

			// Match
			{ "help.match.0", "match|Matches|2:12|395105483|5b6341f92aaa88af50f55dd4550cfeed38ffa70d" },
			{ "help.match.1", "set|Sets|1:59|395105518|893e47fd078d6079a7931c8b920f1cd6b6bb5170" },
			{ "help.match.2", "tourn|Tournaments|1:07|395105531|b92a52c09873d0afcdb606271da7cb3544d5acb0050052f72ccbebcf3974ecf9" },
			{ "help.match.3", "start|Start and end|1:27|395221269|37c4198be51466a0e22bce240de0269e149159fc" },
			{ "help.match.4", "pause|Pause and resume|0:36|395221256|8d5e55ff721eb35077218e348d100d076c1b6288" },

			// RallyFlow
			{ "help.rally.0", "intro|Introduction|2:34|441857195|42055e99a62bd0b6b690ad4abdd48aa74ff58fd7" },
			{ "help.rally.1", "score|Scoreboard" },
			{ "help.rally.2", "team|Team bar" },
			{ "help.rally.3", "level|Detail levels" },

			{ "help.rally.score.0", "area|Scoreboard area|1:45|395221437|a1a919a63c808fae6080f435653eea3d6121bd23" },
			{ "help.rally.score.1", "undo|Undo|0:50|395221475|a147d19008c0f3de2bc7f7a29a0143347e78d805" },

			{ "help.rally.team.0", "lineup|Lineups|2:24|395359132|18ddd37e1165cb881a80a82958851b145e1a5144" },
			{ "help.rally.team.1", "swap|Libero swaps|0:47|395359122|66555d7e290e057b1100c6f81105f7df562273e3" },
			{ "help.rally.team.2", "sub|Substitutions|1:33|395359163|7fe7af867d142cfb8b8b1eb472d2bc88967c7cb7" },

			{ "help.rally.level.0", "over|Overview|1:03|441857222|c53c02b7475075a0b9f3855561e1776f1e34a98c" },
			{ "help.rally.level.1", "low|Low|2:57|441898612|74a329af20863f2fe1eeba461238b1b512fa186f" },
			{ "help.rally.level.2", "med|Medium|6:59|441898671|d3b6937a655f0a6df2f87f00dc1389d69856fef6" },
			{ "help.rally.level.3", "high|High|2:52|442235696|0ea67d713e2cca7b1833656640f67a4d2d35d8dd" },
			{ "help.rally.level.4", "max|Maximum|2:32|442235724|346229a77a8f8ac805d3200bd11d8abbad8eba18" },
			{ "help.rally.level.5", "custom|Custom|1:33|442235643|5f4da9154ec5c412ff5e802add3d7916d213efed" },

			// Legacy
			{ "help.legacy.0", "basic|Basics|3:10|441495807|3ac99113cf40a9038e7b6926226599a98ab63f1e" },
			{ "help.legacy.1", "info|Additional Info|2:47|441495775|f165a23d54fea20ea800c12a488b353ee3e2b71f" },

			// Analyze
			{ "help.analyze.0", "dash|Dashboards|1:11|395099185|e78c2404c493ba1bfe33addef135535d73083977" },
			{ "help.analyze.1", "report|Reports|1:16|395099210|385de8937f73490174281916d458259e2971e4b2" },
			{ "help.analyze.2", "type|Report types" },
			{ "help.analyze.3", "agg|Cumulative stats|1:18|395099170|3f9a98f2f9b5b6f065a86436a8c2a4a51bb92b4a" },
			{ "help.analyze.4", "filter|Filtering season stats|2:46|585587695|55dba7b4c8505a2622127ca791344c99eacd09dc" },
			{ "help.analyze.5", "career|Career stats|1:43|441495338|b30ec26fc9f66affebfa0c2079e221a6e1320f8b" },
			{ "help.analyze.6", "custom|Custom reports|3:35|585664732|cbe98c0d72aa40ec568d27119744a3c15ef8a5bb" },

			{ "help.analyze.type.0", "grid|Stat tables|4:13|395099237|387eabde5f652be9ac70cdea8ca8385bd6e061b3" },
			{ "help.analyze.type.1", "bar|Bar graphs|1:38|585604728|24f7b4ebe9f28b68af7fda833058153a189bc211" },
			{ "help.analyze.type.2", "shot|Shot charts|2:32|395099221|e406782dec3cf73a7000de4d9c79e224617ed556" },
			{ "help.analyze.type.3", "heat|Heat maps|2:32|395099193|280710cd29a09fe1d5098f9755914e4c1c5e152a" },
			{ "help.analyze.type.4", "trend|Trend graphs|2:21|585604980|17a5a34c3ccbcd0035315208e48af73a96c304b5" },
			{ "help.analyze.type.5", "momentum|Momentum charts|2:23|585664622|d2f00a8d089acb99fb465df4768df8062c29e93d" },

			// Export
			{ "help.export.0", "pdf|PDFs|1:46|585598619|e59a792d7a369b32f39d4a4a931f4d97055cf6c3" },
			{ "help.export.1", "maxpreps|MaxPreps|1:19|585599996|0769521ae39b0ef7a8b70cc7859c59a3dd7bcb58" },

			// Raw
			{ "help.raw.0", "pbp|Play-by-Play|4:24|585664851|8c68eb6675b0f8fe34a1c011c2ce530b3c623326" },
			{ "help.raw.1", "tally|Tally Stats|3:30|585664922|3b2887c41b4a2db73f57828e548f062759892785" },
			
			/* Import */

			{ "import", "Import" },
			{ "import.new", "Would you like to import organization '[]' from the ISV file?" },
			{ "import.merge", "Would you like to merge '[]' with the existing organization?" },

			{ "import.name", "Please enter a name for the team:" },
			{ "import.team", "Would you like to merge '[]' with the existing team?" },
			{ "import.season", "Are all matches in this import from the same season?" },
			{ "import.multi", "You need to import seasons one at a time. Please choose a season to import." },

			{ "import.valid", "Ready to begin import. Please note that large imports may take a few minutes." },
			{ "import.begin", "Begin" },
			{ "import.success", "Import successful! You can now access '[]' from the Teams page." },

			{ "import.err", "An error occurred while importing the ISV file." },
			{ "import.err.sub", "You must have at least Coach access in order to import ISV files." },
			{ "import.err.full", "You're already using all the [] allowed by your license." },
			{ "import.err.team", "The team name must be unique within the parent Organization." },
			{ "import.err.season", "All matches must have the Season tag defined." },
			{ "import.err.multi", "That season already exists, you cannot merge seasons." },

			/* Model */

			// User
			{ "user.singular", "User" },

			{ "user.role.0", "director|Director" },
			{ "user.role.1", "coach|Coach" },
			{ "user.role.2", "statistician|Statistician" },
			{ "user.role.3", "fan|Parent / Fan" },
			{ "user.role.4", "player|Player" },
			{ "user.role.5", "media|Media" },

			{ "user.level.0", "0|Media" },
            { "user.level.1", "1|Player" },
            { "user.level.2", "2|Fan" },
            { "user.level.3", "3|Statistician" },
            { "user.level.4", "4|Coach" },
            { "user.level.5", "5|Director" },

			// Organization
			{ "organization.singular", "Organization" },
			{ "organization.plural", "Organizations" },

			{ "organization.mascot", "Mascot" },
			{ "organization.color", "Primary Color" },

			{ "organization.type.0", "club|Club" },
			{ "organization.type.1", "pro|Professional" },
			{ "organization.type.2", "college|College" },
			{ "organization.type.3", "high|High School" },
			{ "organization.type.4", "middle|Middle School" },
			{ "organization.type.5", "elem|Elementary School" },
			{ "organization.type.6", "rec|Recreational" },

			{ "organization.sample", "Sample" },

			// Team
			{ "team.singular", "Team" },
			{ "team.plural", "Teams" },

			{ "team.gender", "Gender" },
			{ "team.level", "Level" },

			{ "team.league", "League" },
			{ "team.division", "Division" },

			{ "team.gender.0", "mens|Men's" },
			{ "team.gender.1", "womens|Women's" },
			{ "team.gender.2", "boys|Boy's" },
			{ "team.gender.3", "girls|Girl's" },
			{ "team.gender.4", "coed|Coed" },

			{ "team.level.hs.0", "varsity|Varsity" },
			{ "team.level.hs.1", "jv|Junior Varsity" },
			{ "team.level.hs.2", "fs|Frosh-Soph" },
			{ "team.level.hs.3", "soph|Sophomore" },
			{ "team.level.hs.4", "frosh|Freshman" },

			{ "team.level.club.0", "18|18U" },
			{ "team.level.club.1", "17|17U" },
			{ "team.level.club.2", "16|16U" },
			{ "team.level.club.3", "15|15U" },
			{ "team.level.club.4", "14|14U" },
			{ "team.level.club.5", "13|13U" },
			{ "team.level.club.6", "12|12U" },
			{ "team.level.club.7", "11|11U" },
			{ "team.level.club.8", "10|10U" },

			{ "team.link.media", "Media Link(s)" },

			// Season
			{ "season.singular", "Season" },
			{ "season.plural", "Seasons" },

			{ "season.start", "Start Date" },
			{ "season.end", "End Date" },

			{ "season.result", "Result" },

			{ "season.winter", "Winter" },
			{ "season.spring", "Spring" },
			{ "season.summer", "Summer" },
			{ "season.fall", "Fall" },

			{ "season.import", "Season Import" },

			// Season-Restore
			{ "restore.title", "Emergency Restore" },
			{ "restore.prompt", "Please contact customer support at support@istatvball.com before attempting a restore." },
			{ "restore.empty", "There are no matches available to restore." },
			{ "restore.create", "Perform restore for match []?" },
			{ "restore.replace", "Match [] already exists, do you want overwrite it?" },
			{ "restore.success", "Match restore completed successfully." },

			// Season Home
			{ "home.title", "Season Home" },
			{ "home.roster", "Roster" },
			{ "home.record", "Record" },

			{ "home.sync", "Sync" },
			{ "home.sync.msg", "Re-sync all data for this season? This may take a while." },

			// Root
			{ "root.title", "Career Link" },
			{ "root.empty", "No linkable seasons found" },

			{ "root.remove", "Remove" },
			{ "root.remove.msg", "Remove career stats link? [] #{} on () will no longer have career stats." },

			{ "root.link", "Link" },
			{ "root.link.msg", "Link to [] #{} from () for career stats?" },
			{ "root.link.tip", "This player is linked to [] #{} from () for career stats." },
			{ "root.link.err", "The linked player has been deleted." },

			// Player
			{ "player.singular", "Player" },
			{ "player.plural", "Players" },

			{ "player.roster", "Roster" },

			{ "player.first", "First name" },
			{ "player.last", "Last name" },
			{ "player.number", "Jersey number" },
			{ "player.deactive", "Deactivated" },

			{ "player.alt", "Alternate number" },
			{ "player.positions", "Positions" },
			{ "player.nickname", "Nickname" },
			{ "player.height", "Height" },

			{ "player.position.0", "s|Setter (S)" },
			{ "player.position.1", "mb|Middle Blocker (MB)" },
			{ "player.position.2", "oh|Outside Hitter (OH)" },
			{ "player.position.3", "opp|Opposite (OPP)" },
			{ "player.position.4", "ds|Defensive Specialist (DS)" },
			{ "player.position.5", "lib|Libero (LIB)" },

			{ "player.year", "Year in school" },
			{ "player.year.0", "senior|Senior" },
			{ "player.year.1", "junior|Junior" },
			{ "player.year.2", "soph|Sophomore" },
			{ "player.year.3", "frosh|Freshman" },
			{ "player.year.4", "red|Redshirt" },
			{ "player.year.5", "eigth|8th Grade" },
			{ "player.year.6", "seventh|7th Grade" },
			{ "player.year.7", "sixth|6th Grade" },
			{ "player.year.8", "fifth|5th Grade" },
			{ "player.year.9", "year5|5th Year" },
			{ "player.year.10", "year4|4th Year" },
			{ "player.year.11", "year3|3rd Year" },
			{ "player.year.12", "year2|2nd Year" },
			{ "player.year.13", "year1|1st Year" },

			{ "player.err.num", "The player's jersey number must be unique on the roster." },
			{ "player.err.alt", "The player's primary and alternate jersey numbers must be different." },

			{ "player.link", "Player" },
			{ "player.link.fans", "Fan(s)" },

			// Lineup
			{ "lineup.singular", "Lineup" },
			{ "lineup.plural", "Lineups" },

			{ "lineup.builder.starter", "Tap to select player and position for each rotation" },
			{ "lineup.builder.sub", "Tap to select player(s) subbing in/out for each rotation" },
			{ "lineup.builder.swapin", "Tap to select player(s) swapping in/out for each rotation" },

			{ "lineup.lib", "Lib" },
			{ "lineup.empty", "?" },

			{ "lineup.starter", "Starters" },
			{ "lineup.sub", "Subs" },
			{ "lineup.swap", "Swaps" },

			{ "lineup.rot", "Rotation" },
			{ "lineup.libero", "Libero" },
			{ "lineup.clear", "Clear" },

			{ "lineup.number", "Number" },
			{ "lineup.position", "Position" },

			{ "lineup.position.0", "s|Setter" },
			{ "lineup.position.1", "mb|Middle Blocker" },
			{ "lineup.position.2", "oh|Outside Hitter" },
			{ "lineup.position.3", "opp|Opposite" },
			{ "lineup.position.4", "ds|DS" },
			{ "lineup.position.5", "lib|Libero" },

			{ "lineup.err.count", "You must have at least 6 players on the Roster before creating a lineup." },
			{ "lineup.err.player", "All zones 1-6 must have both a player and position selected." },
			{ "lineup.err.lib", "If only one libero is being used, it must be Libero 1." },
			{ "lineup.err.pos", "All zones 1-6 must have a position selected. Use the green button in each player area to select the position." },
			{ "lineup.err.dup", "[] is listed more than once in the lineup." },
			{ "lineup.err.name", "The lineup name must be unique within this season." },

			// Lineup-Replace
			{ "replace.1", "1" },
			{ "replace.2", "2" },

			{ "replace.in", "In" },
			{ "replace.out", "Out" },

			{ "replace.start", "Start" },
			{ "replace.confirm", "Confirm" },
			{ "replace.area", "Area" },

			{ "replace.sub", "Substitution" },
			{ "replace.sub.invalid", "Rotation [] has an invalid entry. A player is either missing, duplicated, or does not have a position defined." },
			{ "replace.sub.dup", "Player [] is substituted In or Out in more than one rotation." },

			{ "replace.swapin", "Libero Swap" },
			{ "replace.swapin.invalid", "Rotation [] has an invalid entry. A player is either missing or duplicated." },
			{ "replace.swapin.dup", "Player [] is swapped Out in more than one rotation." },
			{ "replace.swapin.lib", "You must have a libero defined in the starting lineup." },

			// Lineup-Auto
			{ "auto.sub", "Auto Substitution" },
			{ "auto.swapin", "Auto Libero Swap" },
			{ "auto.for", "in for" },

			// Lineup-Save
			{ "save.title", "Save Lineup" },
			{ "save.msg", "Enter a name for the new lineup." },
			{ "save.field", "Name" },
			{ "save.success", "Lineup '[]' has been successfully saved." },

			// Coach
			{ "coach.singular", "Coach" },
			{ "coach.plural", "Coaches" },

			{ "coach.first", "First name" },
			{ "coach.last", "Last name" },
			{ "coach.nickname", "Nickname" },

			{ "coach.type.0", "head|Head Coach" },
			{ "coach.type.1", "asst|Assistant Coach" },
			{ "coach.type.2", "manager|Manager" },

			{ "coach.link", "Coach" },

			// Statistician
			{ "statistician.singular", "Statistician" },
			{ "statistician.plural", "Statisticians" },

			{ "statistician.first", "First name" },
			{ "statistician.last", "Last name" },
			{ "statistician.nickname", "Nickname" },

			{ "statistician.type.0", "coach|Coach" },
			{ "statistician.type.1", "player|Player" },
			{ "statistician.type.2", "parent|Parent" },
			{ "statistician.type.3", "student|Student" },
			{ "statistician.type.4", "volunteer|Volunteer" },
			{ "statistician.type.5", "official|Official" },

			{ "statistician.link", "Statistician" },

			// Opponent
			{ "opponent.singular", "Opponent" },
			{ "opponent.plural", "Opponents" },

			{ "opponent.org", "Organization" },
			{ "opponent.team", "Team" },

			{ "opponent.mascot", "Mascot" },
			{ "opponent.color", "Primary Color" },

			{ "opponent.anon", "Anon" },

			// Venue
			{ "venue.singular", "Venue" },
			{ "venue.plural", "Venues" },

			{ "venue.court.type", "Court type" },
			{ "venue.court.type.0", "default|Default" },
			{ "venue.court.type.1", "wood|Wood" },
			{ "venue.court.type.2", "tile|Color tiles" },

			{ "venue.court.line", "Line color" },
			{ "venue.court.inner", "Inner color" },
			{ "venue.court.outer", "Outer color" },

			// Tournament
			{ "tournament.singular", "Tournament" },
			{ "tournament.plural", "Tournaments" },

			{ "tournament.venue", "Venue" },
			{ "tournament.result", "Result" },
			{ "tournament.division", "Division" },
			{ "tournament.seed", "Seed" },

			// Tournament Day
			{ "day.singular", "Day" },
			{ "day.plural", "Days" },

			// Match
			{ "match.singular", "Match" },
			{ "match.plural", "Matches" },

			{ "match.new", "New Match" },
			{ "match.sync", "Rally Sync" },
			{ "match.progress", "In Progress" },
			{ "match.future", "Future Match" },
			{ "match.video", "From Video" },
			{ "match.paper", "From Paper" },

			{ "match.won", "Won" },
			{ "match.lost", "Lost" },
			{ "match.tied", "Tied" },

			{ "match.result.0", "0|Won" },
			{ "match.result.1", "1|Lost" },
			{ "match.result.2", "2|Tied" },

			{ "match.record", "Recording" },
			{ "match.date", "Date" },
			{ "match.time", "Time" },
			{ "match.anon", "Anonymous opponent?" },
			{ "match.sets", "Number of sets" },

			{ "match.opp", "Opponent" },
			{ "match.opp.abbrev", "OPPNT" },
			{ "match.opp.vs", "vs" },

			{ "match.tourn", "Tournament" },
			{ "match.type", "Match Type" },
			{ "match.result", "Match Result" },
			{ "match.format", "Score Format" },
			{ "match.league", "League" },
			{ "match.home", "Home/Away" },
			{ "match.stat", "Statistician" },
			{ "match.venue", "Venue" },
			{ "match.attend", "Attendance" },
			{ "match.ref1", "1st Referee" },
			{ "match.ref2", "2nd Referee" },

			{ "match.record.0", "live|Live" },
			{ "match.record.1", "future|Future Match" },
			{ "match.record.2", "paper|From Paper" },
			{ "match.record.3", "video|From Video" },
			{ "match.record.4", "rallysync|Using RallySync" },

			{ "match.type.0", "regular|Regular Season" },
			{ "match.type.1", "pre|Pre-Season" },
			{ "match.type.2", "post|Post-Season" },
			{ "match.type.3", "playoff|Playoff" },
			{ "match.type.4", "pool|Pool Play" },
			{ "match.type.5", "scrimmage|Scrimmage" },

			{ "match.format.0", "1.15|1 set to 15" },
			{ "match.format.1", "1.25|1 set to 25" },
			{ "match.format.2", "1.30|1 set to 30" },
			{ "match.format.3", "2.3.15|2 of 3 sets to 15 (3rd to 15)" },
			{ "match.format.4", "2.3.19|2 of 3 sets to 19 (3rd to 15)" },
			{ "match.format.5", "2.3.21|2 of 3 sets to 21 (3rd to 15)" },
			{ "match.format.6", "2.3.25|2 of 3 sets to 25 (3rd to 15)" },
			{ "match.format.7", "2.3.25b|2 of 3 sets to 25 (3rd to 25)" },
			{ "match.format.8", "2.3.30|2 of 3 sets to 30 (3rd to 15)" },
			{ "match.format.9", "2.19|2 sets to 19" },
			{ "match.format.10", "2.21|2 sets to 21" },
			{ "match.format.11", "2.25|2 sets to 25" },
			{ "match.format.12", "3.5.25|3 of 5 sets to 25 (5th to 15)" },
			{ "match.format.13", "3.5.25b|3 of 5 sets to 25 (5th to 25)" },
			{ "match.format.14", "3.5.25c|3 of 5 sets to 25 (3rd-5th to 15)" },
			{ "match.format.15", "3.5.30|3 of 5 sets to 30 (5th to 15)" },
			{ "match.format.16", "3.19|3 sets to 19" },
			{ "match.format.17", "3.21|3 sets to 21" },
			{ "match.format.18", "3.25|3 sets to 25" },
			{ "match.format.19", "3.25b|3 sets to 25 (3rd to 15)" },
			{ "match.format.20", "5.25|5 sets to 25" },

			{ "match.league.0", "league|League" },
			{ "match.league.1", "nonleague|Non-League" },

			{ "match.home.0", "home|Home" },
			{ "match.home.1", "away|Away" },
			{ "match.home.2", "neutral|Neutral" },

			{ "match.unlock", "Reopen Match" },
			{ "match.unlock.msg", "Reopen ended match so that stat recording can continue?" },

			// Match-End
			{ "match.end", "End Match" },
			{ "match.end.win", "End this match with [] winning " },
			{ "match.end.tie", "End this match with a tie " },
			{ "match.end.result", "[]-{}?" },

			// Match-Export
			{ "match.export", "Export" },
			{ "match.export.0", "maxpreps|MaxPreps" },
			{ "match.export.1", "bound|Bound" },

			// Set
			{ "set.singular", "Set" },
			{ "set.plural", "Sets" },

			{ "set.start", "Start" },
			{ "set.resume", "Resume" },

			{ "set.new", "New Set" },
			{ "set.sync", "Rally Sync" },
			{ "set.progress", "In Progress" },
			{ "set.won", "Won" },
			{ "set.lost", "Lost" },
			{ "set.tied", "Tied" },

			{ "set.serve", "Serving First" },
			{ "set.side", "Court Side" },
			{ "set.type", "Lineup Type" },
			{ "set.lineup", "Lineup" },
			{ "set.rotation", "Rotation" },
			{ "set.points", "Points" },

			{ "set.side.0", "sidea|Left/Top" },
			{ "set.side.1", "sideb|Right/Bottom" },

			{ "set.type.0", "lineup|Pre-Created Lineup" },
			{ "set.type.1", "blank|Blank Lineup" },

			{ "set.info", "Set Info" },
			{ "set.log", "Play-by-Play" },
			{ "set.tally", "Tally Stats" },

			{ "set.info.abbrev", "Info" },
			{ "set.log.abbrev", "PbP" },
			{ "set.tally.abbrev", "Tally" },

			{ "set.err.roster", "You must have at least 6 players on the roster before starting a Set." },

			{ "set.unlock", "Reopen Set" },
			{ "set.unlock.msg", "Reopen ended set so that stat recording can continue?" },

			// Set-End
			{ "set.end", "End Set" },
			{ "set.end.win", "End Set [] with {} winning " },
			{ "set.end.tie", "End Set [] tied " },
			{ "set.end.result", "[]-{}?" },

			// Play-by-Play
			{ "log.subject", "iStatVball 3 Play-by-Play" },
                { "log.title", "Play-by-Play" },
			{ "log.abbrev", "PbP" },
			{ "log.events", "Events" },

			// Tally
			{ "tally.played", "Played in set" },

			{ "tally.raw", "Raw" },
			{ "tally.adjust", "Adjust" },
			{ "tally.total", "Total" },

			/* Record */

			// General
			{ "record.sample", "Sample Stats" },
			{ "record.sample.msg", "You can practice recording stats with the Sample Organization, but the stats will not be saved." },

			{ "record.err.engine", "This set was created using a different Stat Engine than your current selection in Settings." },
			{ "record.err.setter", "You have Auto Set configured to 'Assists + Attempts' but do not have a designated Setter (S) on the court. Assists will NOT be auto recorded." },

			// ScoreBoard
			{ "score.pause", "Pause" },
			{ "score.end", "End" },
			{ "score.switch", "Switch" },
			{ "score.timeout", "Timeout" },
			{ "score.tout", "T.Out" },
			{ "score.fault", "Fault" },
			{ "score.sets", "Sets" },
			{ "score.undo", "Undo" },
			{ "score.auto", "Undo AA" },

			{ "score.sides", "Switch Sides" },
			{ "score.sides.msg", "Switch sides of court for both teams?" },

			{ "score.poss", "Possession" },
			{ "score.poss.msg", "Change serve possession to []?" },

			{ "score.call", "Timeout" },
			{ "score.call.msg", "Call a timeout for []?" },

			{ "score.rally", "Undo Rally" },
			{ "score.rally.msg", "Undo all stats from current rally?" },

			// TeamBar
			{ "teambar.lineup", "Lineup" },
			{ "teambar.rotation", "Rotation" },
			{ "teambar.server", "Server" },
			{ "teambar.libero", "Libero" },
			{ "teambar.lib", "Lib" },
			{ "teambar.player", "Player" },
			{ "teambar.swapin", "Swap In" },
			{ "teambar.swpin", "Swp In" },
			{ "teambar.in", "In" },
			{ "teambar.swapout", "Swap Out" },
			{ "teambar.swpout", "Swp Out" },
			{ "teambar.out", "Out" },
			{ "teambar.subs", "Subs" },
			{ "teambar.sub", "Sub" },
			{ "teambar.cancel", "Cancel" },
			{ "teambar.done", "Done" },
			{ "teambar.na", "--" },

			{ "teambar.sub.title", "Sub Warning" },
			{ "teambar.sub.roster", "There are no available roster players to substitute." },
			{ "teambar.sub.none", "There are no substitutions remaining. Continue anyway?" },
			{ "teambar.sub.none1", "There are not enough substitutions remaining. Continue anyway?" },
			{ "teambar.sub.invalid", "That appears to be an invalid substitution. Continue anyway?" },

			{ "teambar.sub.warn", "You only have [] substitutions remaining." },
			{ "teambar.sub.warn1", "You only have 1 substitution remaining." },

			// Drawer
			{ "drawer.report", "Live Stats" },
			{ "drawer.log", "Play-by-Play" },
			
			// Court
			{ "court.row.0", "0|Unknown" },
			{ "court.row.1", "1|Front Row" },
			{ "court.row.2", "2|Back Row" },

			// Markers
			{ "marker.serve", "S" },
			{ "marker.first", "1" },
			{ "marker.second", "2" },
			{ "marker.third", "3" },
			{ "marker.block", "B" },
			{ "marker.over", "O" },

			/* History */

			// Actions
			{ "history.action", "Action" },
			{ "history.action.0", "point|Point" },
			{ "history.action.1", "serve|Serve" },
			{ "history.action.2", "receive|Receive" },
			{ "history.action.3", "second|2nd Ball" },
			{ "history.action.4", "third|3rd Ball" },
			{ "history.action.5", "defense|Defense" },
			{ "history.action.6", "first|1st Ball" },
			{ "history.action.7", "freeball|Freeball" },
			{ "history.action.8", "putback|Putback" },
			{ "history.action.9", "block|Block" },
			{ "history.action.10", "over|Over" },
			{ "history.action.11", "pass|Pass" },
			{ "history.action.12", "set|Set" },			// Legacy

			// Selectors
			{ "history.selector.0", "set|Set" },
			{ "history.selector.1", "attack|Attack" },
			{ "history.selector.2", "free|Free" },

			// Results
			{ "history.result", "Result" },
			{ "history.result.0", "att|Attempt" },
			{ "history.result.1", "err|Error" },
			{ "history.result.2", "ace|Ace" },
			{ "history.result.3", "assist|Assist" },
			{ "history.result.4", "kill|Kill" },
			{ "history.result.5", "block|Solo" },
			{ "history.result.6", "blockAssist|Assist" },
			{ "history.result.7", "blockAssists|Assists" },
			{ "history.result.8", "dig|Dig" },

			{ "history.result.abbrev.0", "att|Att" },
			{ "history.result.abbrev.1", "err|Err" },
			{ "history.result.abbrev.2", "ace|Ace" },
			{ "history.result.abbrev.3", "assist|Asst" },
			{ "history.result.abbrev.4", "kill|Kill" },
			{ "history.result.abbrev.5", "block|Solo" },
			{ "history.result.abbrev.6", "blockAssist|Asst" },
			{ "history.result.abbrev.7", "blockAssists|Assts" },
			{ "history.result.abbrev.8", "dig|Dig" },

			// Updates
			{ "history.update.0", "switch|Side Switch" },
			{ "history.update.1", "poss|Possession Change" },
			{ "history.update.2", "timeout|Timeout" },
			{ "history.update.3", "forced|+" },
			{ "history.update.4", "rotation|Rotation Change" },
			{ "history.update.5", "score|Score Change" },
			{ "history.update.6", "end|Ended" },

			// Lineups
			{ "history.lineup.0", "replace|Lineup Change" },
			{ "history.lineup.1", "sub|Sub [] in for {}" },
			{ "history.lineup.2", "swapin|Swap In [] for {}" },
			{ "history.lineup.3", "swapout|Swap Out [] for {}" },

			// Errors
			{ "history.error", "Error" },
			{ "history.error.0", "out|Out" },
			{ "history.error.1", "net|Net" },
			{ "history.error.2", "ant|Ant" },
			{ "history.error.3", "four|4 Hits" },
			{ "history.error.4", "team|Down" },
			{ "history.error.5", "pass|Down" },
			{ "history.error.6", "set|Down" },
			{ "history.error.7", "down|Down" },
			{ "history.error.8", "x|Down" },
			{ "history.error.9", "bhe|BHE" },
			{ "history.error.10", "tre|TRE" },
			{ "history.error.11", "fault|Fault" },
			{ "history.error.12", "block|Block" },

			/* Action Menu */

			{ "action.anon", "Player" },
			{ "action.anon.num", "#" },

			// Actions
			{ "action.0", "serve|Serve" },
			{ "action.1", "receive|Receive" },
			{ "action.2", "first|1st Ball" },
			{ "action.3", "second|2nd Ball" },
			{ "action.4", "third|3rd Ball" },
			{ "action.5", "defense|Defense" },
			{ "action.6", "freeball|Free Ball" },
			{ "action.7", "putback|Putback" },
			{ "action.8", "block|Block" },
			{ "action.9", "over|Overpass" },

			// Actions-Rating
			{ "action.rating.0", "serve|Serve" },
			{ "action.rating.1", "receive|Receive" },
			{ "action.rating.2", "first|1st Ball" },
			{ "action.rating.3", "second|2nd Ball (Set)" },
			{ "action.rating.4", "defense|Defense" },
			{ "action.rating.5", "freeball|Free Ball" },
			{ "action.rating.6", "putback|Putback" },

			// Actions-Abbreviated
			{ "action.abbrev.0", "serve|Serve" },
			{ "action.abbrev.1", "receive|Recv" },
			{ "action.abbrev.2", "first|1st" },
			{ "action.abbrev.3", "second|2nd" },
			{ "action.abbrev.4", "third|3rd" },
			{ "action.abbrev.5", "defense|Dfnse" },
			{ "action.abbrev.6", "freeball|Free" },
			{ "action.abbrev.7", "putback|Putbk" },
			{ "action.abbrev.8", "block|Block" },
			{ "action.abbrev.9", "over|Over" },

			// Errors
			{ "error.0", "out|Out" },
			{ "error.1", "net|Net" },
			{ "error.2", "ant|Antenna" },
			{ "error.3", "four|4 Hits" },
			{ "error.4", "team|Down" },
			{ "error.5", "pass|Down" },
			{ "error.6", "set|Down" },

			{ "error.player", "Down" },

			// Titles
			{ "title.0", "pass03|Pass" },
			{ "title.1", "pass04|Pass" },
			{ "title.2", "set|Set" },
			{ "title.3", "serve|Serve" },

			// Ratings
			{ "rating.pass03.0", "2|1" },
			{ "rating.pass03.1", "3|2" },
			{ "rating.pass03.2", "4|3" },

			{ "rating.pass04.0", "2|2" },
			{ "rating.pass04.1", "3|3" },
			{ "rating.pass04.2", "4|4" },

			{ "rating.set.0", "2|2" },
			{ "rating.set.1", "3|3" },
			{ "rating.set.2", "4|4" },

			{ "rating.serve.0", "1|1" },
			{ "rating.serve.1", "2|2" },
			{ "rating.serve.2", "3|3" },

			// Modifiers

			// Keys
			{ "modifier.0", "serve|" },
			{ "modifier.1", "set|" },
			{ "modifier.2", "attack2|" },
			{ "modifier.3", "attack3|" },
			{ "modifier.4", "free|" },
			{ "modifier.5", "defense|" },
			{ "modifier.6", "pass|" },
			{ "modifier.7", "over|" },
			{ "modifier.8", "block|" },

			// Serve
			{ "modifier.serve.0", "jump|Jump" },
			{ "modifier.serve.1", "float|Float" },
			{ "modifier.serve.2", "jmpfloat|J.Float" },
			{ "modifier.serve.3", "topspin|T.Spin" },
			{ "modifier.serve.4", "under|Under" },

			// Set
			{ "modifier.set.0", "one|1-Hand" },
			{ "modifier.set.1", "two|2-Hand" },
			{ "modifier.set.2", "bump|Bump" },

			// Attack (2nd ball)
			{ "modifier.attack2.0", "down|Down" },
			{ "modifier.attack2.1", "dump|Dump" },
			{ "modifier.attack2.2", "set|Set" },
			{ "modifier.attack2.3", "spike|Spike" },

			// Attack (3rd ball)
			{ "modifier.attack3.0", "down|Down" },
			{ "modifier.attack3.1", "tip|Tip" },
			{ "modifier.attack3.2", "spike|Spike" },
			{ "modifier.attack3.3", "shot|Shot" },
			{ "modifier.attack3.4", "set|Set" },

			// Free
			{ "modifier.free.0", "down|Down" },
			{ "modifier.free.1", "bump|Bump" },
			{ "modifier.free.2", "set|Set" },

			// Defense
			{ "modifier.defense.0", "bump|Bump" },
			{ "modifier.defense.1", "hand|Hand" },
			{ "modifier.defense.2", "pancake|Pancke" },

			// Pass (Receive, 1stBall, PutBack, FreeBall)
			{ "modifier.pass.0", "bump|Bump" },
			{ "modifier.pass.1", "hand|Hand" },

			// Overpass
			{ "modifier.over.0", "spike|Spike" },
			{ "modifier.over.1", "block|Block" },

			// Block
			{ "modifier.block.0", "one|1-Hand" },
			{ "modifier.block.1", "two|2-Hand" },
			{ "modifier.block.2", "joust|Joust" },

			// Selectors

			// 2nd Ball
			{ "selector.second.0", "set|Set" },
			{ "selector.second.1", "attack|Attack" },

			// 3rd Ball
			{ "selector.third.0", "attack|Attack" },
			{ "selector.third.1", "free|Free" },

			// Lineup
			{ "selector.lineup.0", "swapin|Swap In" },
			{ "selector.lineup.1", "swapout|Swap Out" },
			{ "selector.lineup.2", "sub|Sub" },
			{ "selector.lineup.3", "replace|Replace" },

			// Update
			{ "selector.update.0", "switch|Switch Sides" },
			{ "selector.update.1", "poss|Change Poss" },
			{ "selector.update.2", "score|Update Score" },
			{ "selector.update.3", "timeout|Timeout" },
			{ "selector.update.4", "rotation|Rotate" },
			{ "selector.update.5", "forced|Forced Point" },
			{ "selector.update.6", "end|End Set" },

			// Faults

			// Keys
			{ "fault.0", "serve|" },
			{ "fault.1", "receive|" },
			{ "fault.2", "set|" },
			{ "fault.3", "attack2|" },
			{ "fault.4", "attack3|" },
			{ "fault.5", "free|" },
			{ "fault.6", "defense|" },
			{ "fault.7", "pass|" },
			{ "fault.8", "block|" },

			// Serve
			{ "fault.serve.0", "fault|Fault" },
			{ "fault.serve.1", "foot|Foot" },
			{ "fault.serve.2", "toss|Toss" },
			{ "fault.serve.3", "time|Time" },
			{ "fault.serve.4", "olap|Overlp" },
			{ "fault.serve.5", "rot|Rot" },

			// Receive
			{ "fault.receive.0", "fault|Fault" },
			{ "fault.receive.1", "double|Double" },
			{ "fault.receive.2", "throw|Throw" },
			{ "fault.receive.3", "net|Net" },
			{ "fault.receive.4", "under|Under" },
			{ "fault.receive.5", "block|Block" },
			{ "fault.receive.6", "olap|Overlp" },
			{ "fault.receive.7", "rot|Rot" },

			// Set
			{ "fault.set.0", "fault|Fault" },
			{ "fault.set.1", "double|Double" },
			{ "fault.set.2", "throw|Throw" },
			{ "fault.set.3", "net|Net" },
			{ "fault.set.4", "under|Under" },
			{ "fault.set.5", "back|Bckrow" },

			// Attack (2nd Ball)
			{ "fault.attack2.0", "fault|Fault" },
			{ "fault.attack2.1", "net|Net" },
			{ "fault.attack2.2", "under|Under" },
			{ "fault.attack2.3", "over|Over" },
			{ "fault.attack2.4", "back|Bckrow" },
			{ "fault.attack2.5", "double|Double" },
			{ "fault.attack2.6", "throw|Throw" },

			// Attack (3rd Ball)
			{ "fault.attack3.0", "fault|Fault" },
			{ "fault.attack3.1", "net|Net" },
			{ "fault.attack3.2", "under|Under" },
			{ "fault.attack3.3", "over|Over" },
			{ "fault.attack3.4", "back|Bckrow" },
			{ "fault.attack3.5", "double|Double" },
			{ "fault.attack3.6", "throw|Throw" },

			// Free
			{ "fault.free.0", "fault|Fault" },
			{ "fault.free.1", "double|Double" },
			{ "fault.free.2", "throw|Throw" },
			{ "fault.free.3", "net|Net" },
			{ "fault.free.4", "under|Under" },

			// Defense
			{ "fault.defense.0", "fault|Fault" },
			{ "fault.defense.1", "double|Double" },
			{ "fault.defense.2", "throw|Throw" },
			{ "fault.defense.3", "net|Net" },
			{ "fault.defense.4", "under|Under" },
			{ "fault.defense.5", "block|Block" },

			// Pass (1stBall, PutBack, FreeBall)
			{ "fault.pass.0", "fault|Fault" },
			{ "fault.pass.1", "double|Double" },
			{ "fault.pass.2", "throw|Throw" },
			{ "fault.pass.3", "net|Net" },
			{ "fault.pass.4", "under|Under" },

			// Block (Overpass, Block)
			{ "fault.block.0", "fault|Fault" },
			{ "fault.block.1", "net|Net" },
			{ "fault.block.2", "under|Under" },
			{ "fault.block.3", "over|Over" },
			{ "fault.block.4", "double|Double" },
			{ "fault.block.5", "throw|Throw" },

			/* Record Legacy */

			{ "legacy.0", "serve|Serving" },
			{ "legacy.1", "hit|Hitting" },
			{ "legacy.2", "pass|Passing" },
			{ "legacy.3", "set|Setting" },
			{ "legacy.4", "block|Blocking" },
			{ "legacy.5", "defense|Defense" },

			{ "legacy.serve.0", "att|ATT" },
			{ "legacy.serve.1", "ace|ACE" },
			{ "legacy.serve.2", "err|ERR" },

			{ "legacy.serve.rate.0", "0|0" },
			{ "legacy.serve.rate.1", "1|1" },
			{ "legacy.serve.rate.2", "2|2" },
			{ "legacy.serve.rate.3", "3|3" },
			{ "legacy.serve.rate.4", "4|4" },

			{ "legacy.hit.0", "att|ATT" },
			{ "legacy.hit.1", "kill|KILL" },
			{ "legacy.hit.2", "err|ERR" },

			{ "legacy.pass03.0", "0|0" },
			{ "legacy.pass03.1", "1|1" },
			{ "legacy.pass03.2", "2|2" },
			{ "legacy.pass03.3", "3|3" },

			{ "legacy.pass04.0", "0|0" },
			{ "legacy.pass04.1", "1|1" },
			{ "legacy.pass04.2", "2|2" },
			{ "legacy.pass04.3", "3|3" },
			{ "legacy.pass04.4", "4|4" },

			{ "legacy.set.0", "att|ATT" },
			{ "legacy.set.1", "assist|ASST" },
			{ "legacy.set.2", "err|ERR" },

			{ "legacy.block.0", "att|ATT" },
			{ "legacy.block.1", "block|BLK" },
			{ "legacy.block.2", "blockAssist|ASST" },
			{ "legacy.block.3", "err|ERR" },

			{ "legacy.defense.0", "att|ATT" },
			{ "legacy.defense.1", "dig|DIG" },
			{ "legacy.defense.2", "err|ERR" },

			{ "legacy.free", "Hitting- FREE" },
			{ "legacy.free.0", "att|ATT" },
			{ "legacy.free.1", "kill|KILL" },
			{ "legacy.free.2", "err|ERR" },

			/* Analyze */

			// General
			{ "analyze.opp", "Opponent" },
			{ "analyze.opps", "Opponents" },

			{ "analyze.abbrev.opp", "OPPNT" },
			{ "analyze.abbrev.opps", "OPNTS" },

			{ "analyze.career", "Career" },
			{ "analyze.sync", "Sync" },

			{ "analyze.perf", "Cumulative Stats" },
			{ "analyze.perf.msg", "Please note that viewing cumulative career or season stats for the first time may be slow. Subsequent viewings will be faster." },

			// Dimension
			{ "dimension.all", "All" },
			{ "dimension.none", "<none>" },

			{ "dimension.player", "Player" },
			{ "dimension.rotation", "Rotation" },
			{ "dimension.position", "Position" },
			{ "dimension.setter", "Setter" },
			{ "dimension.rating", "Receive Rating" },
			{ "dimension.row", "Court Row" },
			{ "dimension.modifier", "Contact Type" },

			// Dashboard
			{ "dashboard.singular", "Dashboard" },
			{ "dashboard.custom", "Report Builder" },
			{ "dashboard.add", "Add new report" },

			{ "dashboard.title", "Analyze" },
			{ "dashboard.empty", "No Stats Found" },

			// Report
			{ "report.options", "Options" },

			// Custom
			{ "custom.name", "Custom" },
			{ "custom.category", "Category" },
			{ "custom.team", "Team" },
			{ "custom.stat", "Statistic" },
			{ "custom.card", "Show on dashbord card?" },

			{ "custom.dimension", "Analyze" },
			{ "custom.dimension.0", "player|By Player" },
			{ "custom.dimension.1", "rotation|By Rotation" },
			{ "custom.dimension.2", "position|By Position" },
			{ "custom.dimension.3", "setter|By Setter" },
			{ "custom.dimension.4", "rating|By Receive Rating" },
			{ "custom.dimension.5", "row|By Front/Back Row" },
			{ "custom.dimension.6", "modifier|By Contact Type" },

			{ "custom.type", "Type" },
			{ "custom.type.0", "grid|Stat Table" },
			{ "custom.type.1", "bar|Bar Graph" },
			{ "custom.type.2", "shot|Shot Chart" },
			{ "custom.type.3", "heat|Heat Map" },
			{ "custom.type.4", "trend|Trend Graph" },

			{ "custom.err.unique", "The name '[]' has already been used for a dashboard in your account." },

			// Builder
			{ "builder.grid", "Stat Tables" },
			{ "builder.bar", "Bar Graphs" },
			{ "builder.shot", "Shot Charts" },
			{ "builder.heat", "Heat Maps" },
			{ "builder.trend", "Trend Graphs" },

			{ "builder.by", "Analyze by" },
			{ "builder.then", "Then by" },

			// Grid
			{ "grid.total", "Team" },

			// Bar Chart
			{ "bar.team", "Team" },

			// Shot
			{ "shot.legend", "Legend" },
			{ "shot.rating", "Rating" },

			{ "shot.err", "Chart Options" },
			{ "shot.err.msg", "At least one item from each list must be selected." },

			{ "shot.result.0", "att|Attempt" },
			{ "shot.result.1", "suc|Success" },
			{ "shot.result.2", "err|Error" },

			{ "shot.marker", "Markers" },
			{ "shot.marker.0", "start|Start circle" },
			{ "shot.marker.1", "arrow|Arrow" },
			{ "shot.marker.2", "end|End circle" },

			// Heat Map
			{ "heat.areas", "Number of Areas" },
			{ "heat.areasx", "Court Length" },
			{ "heat.areasy", "Court Width" },

			// Trend Graph
			{ "trend.legend", "Legend" },

			// Momentum Chart
			{ "momentum.title.x", "Score" },
			{ "momentum.title.y", "Momentum" },

			{ "momentum.timeout", "Timeout" },
			{ "momentum.sub", "Substitution" },
			{ "momentum.sub.out", "out" },
			{ "momentum.sub.in", "in" },

			// Export
			{ "export.item", "Export" },
			{ "export.record", "Record" },

			{ "export.title", "Report Export" },
			{ "export.success", "Your [] report has been successfully emailed." },

			{ "export.subject", "iStatVball 3 [] Report" },
			{ "export.body", "Your [] report is attached to this email as a PDF file. You can open the file using Adobe Reader, Preview, or other PDF viewers." },

			{ "export.err", "An error occurred sending the export email. Please try again." },
			{ "export.err.support", "Email is not currently supported on this device. Please check your device settings." },
			{ "export.err.dim", "Drill down stat tables can not be exported. Please change 'Then By' to '<none>' then try again." },

			{ "export.single", "Single" },
			{ "export.group", "Group" },

			{ "export.from", "From:" },
			{ "export.to", "To:" },

			{ "export.fan", "Fans" },
			{ "export.media", "Media" },

			{ "export.send", "Send" },

			/* Integrations */
			
			// MaxPreps1
			{ "maxpreps.title", "MaxPreps Export" },
			{ "maxpreps.msg", "Please enter the destination email address for the export." },
			{ "maxpreps.success", "Your MaxPreps export has been successfully emailed. Follow the instructions in the email to upload to MaxPreps." },

			{ "maxpreps.subject", "iStatVball 3 MaxPreps Export" },
            { "maxpreps.body", "Congratulations, your stats data has been successfully exported and is ready to be uploaded to MaxPreps.\n\nTeam: []\nOpponent: {}\nDate: ()\n\nTo upload to MaxPreps:\n\n1.  Save the email attachment to your device or computer.\n\n2.  From your device, login to your account on the MaxPreps website.\n\n3.  From the Account Menu in the upper-right, select your school admin.\n\n4.  Tap on Schedule in the header.\n\n5.  Tap the Pencil Icon for the match you want to upload, then tap Enter Score.\n\n6.  Enter the set scores, then tap Save & Import Stats.\n\n7.  Tap Choose File, then tap Browse to locate your saved file, then tap Import." },

            { "maxpreps.err", "An error occurred sending the MaxPreps export email. Please try again." },
            { "maxpreps.err.support", "Email is not currently supported on this device. Please check your device settings." },

			// MaxPreps2
			{ "maxpreps2.title", "MaxPreps Link" },
			{ "maxpreps2.search", "Search for school" },
			{ "maxpreps2.remove", "Remove" },

			{ "maxpreps2.link", "Organization '[]' successfully linked to MaxPreps." },
			{ "maxpreps2.remove.opp", "Remove MaxPreps link for opponent '[]'?" },

			{ "maxpreps2.export", "MaxPreps Export" },
			{ "maxpreps2.msg", "Export all stats for this match to MaxPreps?" },
			{ "maxpreps2.success", "Congratulations, your stats have been successfully uploaded to MaxPreps!" },

			{ "maxpreps2.err.high", "Your Organization must be of type High School. Please edit your Organization and then try again." },
            { "maxpreps2.err.org", "Your Organization must be linked to MaxPreps. Please edit your Organization, tap the MaxPreps button, and then search for your school." },
            { "maxpreps2.err.opponent", "The match must have an Opponent defined before exporting. Please edit the match, select (or create) an Opponent, and then try again." },
			{ "maxpreps2.err.link", "The match Opponent must be linked to MaxPreps. Please edit the Opponent, tap the MaxPreps button, and then search for the correct school." },
			{ "maxpreps2.err.export", "This match has already been exported to MaxPreps. Any changes should be made directly in the MaxPreps coach admin." },

            { "maxpreps2.err", "An error occurred uploading stats to MaxPreps. []" },
            { "maxpreps2.err.send", "An error occurred uploading stats to MaxPreps. If the problem persists, please contact customer support at support@istatvball.com." },
                
			// Varsity Bound
			{ "bound.title", "Bound" },
			{ "bound.state", "Select State" },
			{ "bound.school", "Select School" },

			{ "bound.link1", "Before uploading to Bound, you first need to link your school." },
			{ "bound.link2", "Link to Bound school '[]'?" },
			{ "bound.link3", "Bound school successfully linked." },

			{ "bound.msg", "Export stats for this match and upload to Bound?" },
			{ "bound.success", "Your match stats were successfully uploaded to Bound." },

			{ "bound.err", "An error occurred connecting to Bound. If the problem persists, please contact support@istatvball.com." },

			/* Video */

			{ "video.cancel", "CANCEL" },

			{ "video.title", "Video Settings" },
			{ "video.sync", "Sync to stats" },
			{ "video.fileid", "Video ID" },
			{ "video.share", "Allow sharing" },
			{ "video.offset", "First serve" },

			{ "video.host", "Host" },
			{ "video.host.0", "youtube|YouTube" },
			{ "video.host.1", "vimeo|Vimeo" },
			
			{ "video.err", "Video" },
			{ "video.err.timeout", "Video could not be played. Please check the Video ID and try again." },
			
			{ "video.rally", "RallySync" },
			{ "video.rally.mobile", "The RallySync feature only runs on tablets. Please try on another device." },
			{ "video.rally.orient", "The RallySync feature requires portrait orientation. Please rotate the device." },

			/* Filter */

			{ "filter.filter", "Filter" },
			{ "filter.clear", "Clear" },

			{ "filter.point", "Point" },
			{ "filter.lineup", "Lineup" },
			{ "filter.update", "Update" },

			{ "filter.rotation", "Rotations" },

			{ "filter.action", "Actions" },
			{ "filter.selector", "Selectors" },
			{ "filter.modifier", "Modifiers" },

			{ "filter.result", "Results" },
			{ "filter.error", "Errors" },
			{ "filter.fault", "Faults" },

			{ "filter.rating", "Ratings" },
			{ "filter.start", "Start Areas" },
			{ "filter.end", "End Areas" },

			{ "filter.ro", "Ro" },
			{ "filter.area", "Area" },
			{ "filter.block", "Block" },

			{ "filter.tag", "Match Filter" },

			/* Admin */

			// Tools
			{ "tools.title", "Admin Tools" },
			{ "tools.level", "Level" },
			{ "tools.trial", "Trial Started" },
			{ "tools.add", "Add" },

			{ "tools.migrate", "New User" },
			
			// Analytics
			{ "analytics.title", "Analytics" },

			{ "analytics.data", "Data" },
			{ "analytics.data.0", "user|User" },
			{ "analytics.data.1", "session|Session" },
			{ "analytics.data.2", "org|Org" },
			{ "analytics.data.3", "season|Season" },
			{ "analytics.data.4", "set|Set" },

			{ "analytics.time", "Time" },

			// Archive
			{ "archive.title", "Archive" },
			{ "archive.limit", "Limit" },
			{ "archive.debug", "Debug" },

			{ "archive.stats1", "Total: []  Done: {}  Delete: ()" },
			{ "archive.stats2", "Archive: []  New: {}  Prog: ()" },
			{ "archive.stats3", "Elapsed: []  Avg: {}  Error: ()" }
		};
	}
}

//
