﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Android.OS;
using Android.App;
using Android.Views;
using Android.Content.PM;

using AndroidX.Core.View;

using DXLib.Utils;

namespace iStatVball3.Droid;

/*
 * Main activity for entire app. A splash screen is displayed before app launch.
 */
[Activity(Theme = "@style/Maui.SplashTheme", MainLauncher = true, ConfigurationChanges = ConfigChanges.ScreenSize | ConfigChanges.Orientation | ConfigChanges.UiMode | ConfigChanges.ScreenLayout | ConfigChanges.SmallestScreenSize, LaunchMode = LaunchMode.Multiple)]
public class MainActivity : MauiAppCompatActivity
{
	/* Properties */
	public static MainActivity Current { get; private set; }

	/* Methods */

	// Called when application loaded and ready to run
	protected override void OnCreate( Bundle savedInstanceState )
	{
		base.OnCreate( savedInstanceState );
       
        // Hide bottom nav
        if ( DXDevice.IsAndroidR() )
        {
            Window.SetDecorFitsSystemWindows( false );

            IWindowInsetsController windowInsetsController = Window.DecorView.WindowInsetsController;
            windowInsetsController?.Hide( WindowInsetsCompat.Type.NavigationBars() );
        }
        else
        {
            SystemUiFlags uiOptions = SystemUiFlags.HideNavigation;

            Window.DecorView.SystemUiVisibility = (StatusBarVisibility)uiOptions;
        }

        Current = this;
	}

}

//
