﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Microsoft.Maui.LifecycleEvents;
using CommunityToolkit.Maui;

using MR.Gestures;
using FFImageLoading.Maui;
using Plugin.Firebase.Auth;
using Syncfusion.Maui.Core.Hosting;
using SkiaSharp.Views.Maui.Controls.Hosting;

#if IOS
    using Plugin.Firebase.Core.Platforms.iOS;
#else
    using Plugin.Firebase.Core.Platforms.Android;
#endif

using iStatVball3.Handlers.Video;
using DXLib.Video;
using Microsoft.Extensions.Logging;

// Handlers
using EntryHandler = DXLib.UI.Form.Control.EntryHandler;
using DatePickerHandler = DXLib.UI.Control.Picker.DatePickerHandler;
using TimePickerHandler = DXLib.UI.Control.Picker.TimePickerHandler;

namespace iStatVball3;

/*
 * Cross-platform entry point into MAUI app.
 */
public static class MauiProgram
{
    /* Methods */
    
    // Main entry point
    public static MauiApp CreateMauiApp()
    {
        MauiAppBuilder builder = MauiApp.CreateBuilder();

        // Configure app
        builder.UseMauiApp<App>()
               .UseMauiCommunityToolkit()
               .UseSkiaSharp()
               .UseFFImageLoading()
               .ConfigureMRGestures()
               .ConfigureSyncfusionCore()
               .ConfigureFonts( AddFonts )
               .ConfigureMauiHandlers( handlers =>
               {
                   handlers.AddHandler<DXVideo, DXVideoHandler>();
               })
               .RegisterFirebaseServices();

        // Setup platform specific handlers
        RegisterHandlers();
        
        // Required for HybridWebView console debugging
        #if DEBUG
            builder.Services.AddHybridWebViewDeveloperTools();
        #endif
        
        return builder.Build();
    }
    
    // Add all custom app fonts
    private static void AddFonts( IFontCollection fonts )
    {
        fonts.AddFont( "Oswald-Medium.ttf", "Oswald-Medium" );
        fonts.AddFont( "Oswald-Regular.ttf", "Oswald-Regular" );

        fonts.AddFont( "Roboto-Bold.ttf", "Roboto-Bold" );
        fonts.AddFont( "Roboto-BoldItalic.ttf", "Roboto-BoldItalic" );
        fonts.AddFont( "Roboto-Italic.ttf", "Roboto-Italic" );
        fonts.AddFont( "Roboto-Medium.ttf", "Roboto-Medium" );
        fonts.AddFont( "Roboto-Regular.ttf", "Roboto-Regular" );

        fonts.AddFont( "RobotoCondensed-Bold.ttf", "RobotoCondensed-Bold" );
        fonts.AddFont( "RobotoCondensed-Regular.ttf", "RobotoCondensed-Regular" );
        
        fonts.AddFont( "RobotoMono-Regular.ttf", "RobotoMono-Regular" );
    }
    
    // Setup handlers for device specific code
    private static void RegisterHandlers()
    {
        EntryHandler.RemoveBorder();
        DatePickerHandler.RemoveBorder();
        TimePickerHandler.RemoveBorder();
    }
    
    // Plugin.Firebase boilerplate initialization
    private static void RegisterFirebaseServices( this MauiAppBuilder builder )
    {
        builder.ConfigureLifecycleEvents( events => 
        {
            #if IOS
                events.AddiOS( iOS => iOS.WillFinishLaunching( (_,unused) =>
                {
                    CrossFirebase.Initialize(); 
                    return false; 
                }));
            #elif ANDROID
                events.AddAndroid( android => android.OnCreate( (activity, _) => CrossFirebase.Initialize( activity ) ) );
            #endif
        });
        
        builder.Services.AddSingleton( _ => CrossFirebaseAuth.Current );
    }    
}

//
