/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

#nullable enable

using Microsoft.Maui.Handlers;

using iStatVball3.Platforms.iOS.DXLib.Video;
using DXLib.Video;

namespace iStatVball3.Handlers.Video;

/*
 * iOS specific mapping of video player API to native implementation.
 */
public partial class DXVideoHandler : ViewHandler<DXVideo,DXVideoPlayer>
{
    /* Methods */
    public DXVideoHandler( IPropertyMapper mapper, CommandMapper? commandMapper = null ) : base( mapper, commandMapper )
    {}

    // Creates platform specific player
    protected override DXVideoPlayer CreatePlatformView() => new( VirtualView );

    // Disposes MAUI handler
    protected override void DisconnectHandler( DXVideoPlayer platformView )
    {
        platformView.Dispose();
        
        base.DisconnectHandler( platformView );
    }

    // PROPERTY MAPPINGS
    public static void MapShowControls( DXVideoHandler handler, DXVideo video )
    {
        handler.PlatformView.UpdateShowControls();
    }

    public static void MapSource( DXVideoHandler handler, DXVideo video )
    {
        handler.PlatformView.UpdateSource();
    }

    public static void MapIsLooping( DXVideoHandler handler, DXVideo video )
    {
        handler.PlatformView.UpdateIsLooping();
    }

    public static void MapPosition( DXVideoHandler handler, DXVideo video )
    {
        handler.PlatformView.UpdatePosition();
    }

    public static void MapSpeed( DXVideoHandler handler, DXVideo video )
    {
        handler.PlatformView.UpdateSpeed();
    }

    // COMMAND MAPPINGS
    public static void MapUpdateStatus( DXVideoHandler handler, DXVideo video, object? args )
    {
        handler.PlatformView.UpdateStatus();
    }

    public static void MapPlayRequested( DXVideoHandler handler, DXVideo video, object? args )
    {
        if ( args is not DXVideoPositionEventArgs eventArgs )
        {
            return;
        }

        TimeSpan position = eventArgs.Position;
        handler.PlatformView.PlayRequested( position );
    }

    public static void MapPauseRequested( DXVideoHandler handler, DXVideo video, object? args )
    {
        if ( args is not DXVideoPositionEventArgs eventArgs )
        {
            return;
        }

        TimeSpan position = eventArgs.Position;
        handler.PlatformView.PauseRequested( position );
    }

    public static void MapStopRequested( DXVideoHandler handler, DXVideo video, object? args )
    {
        if ( args is not DXVideoPositionEventArgs eventArgs )
        {
            return;
        }

        TimeSpan position = eventArgs.Position;
        handler.PlatformView.StopRequested( position );
    }
}

//
