/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

#if IOS || MACCATALYST
#elif ANDROID
#elif (NETSTANDARD || !PLATFORM) || (NET6_0_OR_GREATER && !IOS && !ANDROID)
	using PlatformView = System.Object;
#endif

using DXLib.Video;

namespace iStatVball3.Handlers.Video;

/*
 * MAUI handler mapping cross-platform video player API to native implementations.
 */
public partial class DXVideoHandler
{
	/* Property Mapping */
	public static readonly IPropertyMapper<DXVideo,DXVideoHandler> PropertyMapper = new PropertyMapper<DXVideo,DXVideoHandler>( ViewMapper )
	{
		[nameof(DXVideo.ShowControls)] = MapShowControls,
		[nameof(DXVideo.Source)] = MapSource,
		[nameof(DXVideo.IsLooping)] = MapIsLooping,
		[nameof(DXVideo.Position)] = MapPosition,
		[nameof(DXVideo.Speed)] = MapSpeed
	};

	/* Command Mapping */
	public static readonly CommandMapper<DXVideo,DXVideoHandler> CommandMapper = new( ViewCommandMapper )
	{
		[nameof(DXVideo.UpdateStatus)] = MapUpdateStatus,
		[nameof(DXVideo.PlayRequested)] = MapPlayRequested,
		[nameof(DXVideo.PauseRequested)] = MapPauseRequested,
		[nameof(DXVideo.StopRequested)] = MapStopRequested
	};

	/* Methods */
	public DXVideoHandler() : base( PropertyMapper, CommandMapper )
	{}
}

//
