﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using System.ComponentModel;

namespace DXLib.Video.Source;

/*
 * Provides utility method for converting persisted value to video source string.
 */
public class DXVideoSourceConverter : TypeConverter, IExtendedTypeConverter
{
    /* Methods */
    
    // Convert specified string to URI source
    object IExtendedTypeConverter.ConvertFromInvariantString( string value, IServiceProvider serviceProvider )
    {
        if ( !string.IsNullOrWhiteSpace( value ) )
        {
            return Uri.TryCreate( value, UriKind.Absolute, out var uri ) && (uri.Scheme != DXVideoSource.FileScheme) ? DXVideoSource.FromUri( value ) : DXVideoSource.FromResource( value );
        }

        // Should not happen
        throw new InvalidOperationException();
    }
}

//
