﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using System.ComponentModel;

namespace DXLib.Video.Source;

/*
 * Base class for all available video source types (uri, file, resource).
 */
[TypeConverter(typeof(DXVideoSourceConverter))]
public abstract class DXVideoSource : Element
{
    /* Constants */
    public const string FileScheme = "file";

    /* Methods */

    // Creates URI video source from specified URI
    public static DXVideoSource FromUri( string uri )
    {
        return new DXUriVideoSource { Uri = uri };
    }

    // Creates file video source from specified file URL
    public static DXVideoSource FromFile( string file )
    {
        return new DXFileVideoSource { File = file };
    }

    // Creates resource video source from specified embedded path
    public static DXVideoSource FromResource( string path )
    {
        return new DXResourceVideoSource { Path = path };
    }
}

//
