﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

namespace DXLib.Video.Source;

/*
 * Video source for playing video from a remote URI.
 */
public class DXUriVideoSource : DXVideoSource
{
    /* Properties */
    public string Uri { get => (string) GetValue( UriProperty ); set => SetValue( UriProperty, value ); }
    
    /* Bindings */
    public static readonly BindableProperty UriProperty = BindableProperty.Create( nameof(Uri), typeof(string), typeof(DXUriVideoSource) );
}

//
