﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.Video.Source;

/*
 * Video source for playing video from an embedded resource.
 */
public class DXResourceVideoSource : DXVideoSource
{
    /* Properties */
    public string Path { get => (string)GetValue( PathProperty ); set => SetValue( PathProperty, value ); }
    
    /* Bindings */
    public static readonly BindableProperty PathProperty = BindableProperty.Create( nameof(Path), typeof(string), typeof(DXResourceVideoSource) );
}

//
