﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

namespace DXLib.Video.Source;

/*
 * Video source for playing video from a local file.
 */
public class DXFileVideoSource : DXVideoSource
{
	/* Properties */
	public string File { get => (string) GetValue( FileProperty ); set => SetValue( FileProperty, value ); }

    /* Bindings */
    public static readonly BindableProperty FileProperty = BindableProperty.Create( nameof(File), typeof(string), typeof(DXFileVideoSource) );
}

//
