﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.Utils;

/*
 * Basic utility for reading/writing to the native preferences system. 
 */ 
public static class DXPreferences
{
	/* Methods */
	
	// Getters return type specific value matching specified key

	public static string Get( string key, string defaultValue )
	{
		return Preferences.Default.Get( key, defaultValue );
	}

	public static int Get( string key, int defaultValue )
	{
		return Preferences.Default.Get( key, defaultValue );
	}

	public static bool Get( string key, bool defaultValue )
	{
		return Preferences.Default.Get( key, defaultValue );
	}

	public static DateTime Get( string key, DateTime defaultValue )
	{
		return Preferences.Default.Get( key, defaultValue );
	}

	// Setters save type specific value for specified key

	public static void Set( string key, string value )
	{
		Preferences.Default.Set( key, value );
	}

	public static void Set( string key, int value )
	{
		Preferences.Default.Set( key, value );
	}

	public static void Set( string key, bool value )
	{
		Preferences.Default.Set( key, value );
	}

	public static void Set( string key, DateTime value )
	{
		Preferences.Default.Set( key, value );
	}
}

//
