﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using CommunityToolkit.Mvvm.Messaging.Messages;

namespace DXLib.UI.Form.Message;

/*
 * Used to encapsulate WeakReferenceMessenger pub/sub messages related to DXForm control value changes. 
 */
public class DXFormChangedMessage : ValueChangedMessage<object>
{
	/* Properties */
	public DXFormControl Control => this.Value as DXFormControl;

	/* Methods */
	public DXFormChangedMessage( object value ) : base( value )
	{}
}
//
