﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.UI;

/* 
 * Provides color constants applicable to widgets throughout the UI.
 */
public static class DXColors
{
	/* Constants */

	// Theme colors
	public static readonly Color Transparent = Colors.Transparent;

	public static readonly Color Dark1 = Color.FromArgb( "#07182A" );
	public static readonly Color Dark2 = Color.FromArgb( "#2C3846" );
	public static readonly Color Dark3 = Color.FromArgb( "#404B58" );
	public static readonly Color Dark4 = Color.FromArgb( "#7C8590" );

	public static readonly Color Light1 = Color.FromArgb( "#CCCCCC" );
	public static readonly Color Light2 = Color.FromArgb( "#ECECEC" );
	public static readonly Color Light3 = Color.FromArgb( "#F8F8F8" );
	public static readonly Color Light4 = Color.FromArgb( "#FFFFFF" );

	public static readonly Color Action = Color.FromArgb( "#2196F3" );
	public static readonly Color Positive = Color.FromArgb( "#00BFA5" );
	public static readonly Color Negative = Color.FromArgb( "#FE2C54" );
	public static readonly Color Neutral = Color.FromArgb( "#2C3846" );
	public static readonly Color Warn = Color.FromArgb( "#ED7009" );

	// Pastel colors
	public static readonly Color Accent1 = Color.FromArgb( "#D6F2FF" );		// Blue
	public static readonly Color Accent2 = Color.FromArgb( "#E4FDF9" );		// Green
	public static readonly Color Accent3 = Color.FromArgb( "#F86E89" );		// Red
	public static readonly Color Accent4 = Color.FromArgb( "#855AE2" );		// Purple
	public static readonly Color Accent5 = Color.FromArgb( "#FFAB00" );		// Yellow
	
	/* Methods */
	
	// Returns version of color at specified alpha level
	public static Color ColorWithAlpha( Color color, double alpha )
	{
		return Color.FromRgba( color.Red, color.Green, color.Blue, alpha );
	}
}

//
