﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Collections.ObjectModel;

using DXLib.Data.Model;

namespace DXLib.UI.Control.Tree;

/*
 * Represents one data item within a DXTree checkbox tree node.
 */
public class DXTreeDatum
{
	/* Properties */

	// Parent node key (null for root)
	public string Parent { get; set; }

	// Lookup key
	public string Key { get; set; }

	// Checkbox label
	public string Text { get; set; }

	// Optional associated data model
	public DXModel Model { get; set; }

	// Child checkboxes
	public ObservableCollection<DXTreeDatum> ChildData { get; set; }

	// Controls enabled status for tree node
	public bool IsEnabled { get; set; }
}

//
