﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Globalization;

namespace DXLib.UI.Control.Tree;

/*
 * Required to support custom expand/collapse icons in DXTree controls.
 */
public class DXTreeConverter : IValueConverter
{
    // Returns custom expand/collapse image resource
    public object Convert( object value, Type targetType, object parameter, CultureInfo culture )
    {
        if ( value != null )
        {
            // Check if item is expanded
            bool isExpanded = (bool)value;

            // Return different image sources based on expansion state
            return isExpanded ? "expanded.png" : "collapsed.png";
        }

        return null;
    }

    // Unused
    public object ConvertBack( object value, Type targetType, object parameter, CultureInfo culture )
    {
        throw new NotImplementedException();
    }
}

/*
 * Required to support custom expand/collapse icons in DXTree controls.
 */
public class DXTreeVisibilityConverter : IValueConverter
{
    // Shows/hides custom expand/collapse icon depending on node state
    public object Convert( object value, Type targetType, object parameter, CultureInfo culture )
    {
        // Check if the node has child nodes
        bool? hasChildNodes = (bool?)value;

        // Return true if the node has child nodes, otherwise false (used to control visibility)
        return hasChildNodes;
    }

    // Unused
    public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
    {
        throw new NotImplementedException();
    }
}

//
