﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Syncfusion.Maui.Core;
using Syncfusion.Maui.Inputs;

namespace DXLib.UI.Control.Selector;

/*
 * Implements an SfComboBox for filtering the selection list based on user typed input.
 */
public class DXSearchSelector : DXSelector
{
	/* Methods */
	public DXSearchSelector()
	{
		// Configure for search
		IsFilteringEnabled = true;
		IsEditable = true;
		
		IsClearButtonVisible = true;
		ClearButtonIconColor = DXColors.Dark4;

		TextSearchMode = ComboBoxTextSearchMode.Contains;
		DropDownPlacement = DropDownPlacement.Bottom;
	}
}

//
