﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Form;

#if ANDROID
	using Microsoft.Maui.Controls.Compatibility.Platform.Android;
#endif

namespace DXLib.UI.Control.Picker;

/*
 * Wrapper for MAUI DatePicker that sets default styling. 
 */
public class DXDatePicker : DatePicker
{
	/* Methods */
	public DXDatePicker()
	{
        HeightRequest = DXFormControl.DefaultControlHt;

        Format = "MMMM d, yyyy";
		TextColor = DXColors.Dark1;

		FontFamily = DXFonts.Roboto;
		FontAttributes = FontAttributes.None;
		FontSize = 17;
	}
}

/*
 * MAUI Handler for device specific DatePicker customization.
 */
public static class DatePickerHandler
{
	// Removes picker border
	public static void RemoveBorder()
	{
		Microsoft.Maui.Handlers.DatePickerHandler.Mapper.AppendToMapping( "Borderless", ( handler, view ) =>
		{
			#if ANDROID
				handler.PlatformView.Background = null;
				handler.PlatformView.SetBackgroundColor( Android.Graphics.Color.Transparent );
				handler.PlatformView.BackgroundTintList =
				Android.Content.Res.ColorStateList.ValueOf( Colors.Transparent.ToAndroid() );
			#elif IOS
				handler.PlatformView.BackgroundColor = UIKit.UIColor.Clear;
				handler.PlatformView.Layer.BorderWidth = 0;
				handler.PlatformView.BorderStyle = UIKit.UITextBorderStyle.None;
			#endif
		});
	}
}

//