﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Container;

namespace DXLib.UI.Control.List.Template;

/*
 * DataTemplate specifying layout for a generic, single label row in DXListView. Can be used as either the normal or
 * selected template.
 */
public class DXListTemplate : DXContent
{
	/* Constants */
	protected static readonly Color SelectedColor = DXColors.Light1;
	protected static readonly Color DeselectedColor = DXColors.Light4;

	/* Properties */
	protected readonly DXLabel label;

	/* Methods */
	public DXListTemplate( bool selected = false )
	{
		// Row padding/color
		this.SetBinding( PaddingProperty, "Padding" );
		this.SetBinding( BackgroundColorProperty, "Color" );

		// Label
		label = new DXLabel
		{
			Padding = new Thickness( 5, 0 ),

			BackgroundColor = selected ? SelectedColor : DeselectedColor,
			TextColor = DXColors.Dark1,

			VAlign = TextAlignment.Center,
			
			Horizontal = LayoutOptions.Fill,
			Vertical = LayoutOptions.Fill
		};

		label.SetBinding( Label.TextProperty, "Value" );

		label.SetBinding( Label.TextColorProperty, "TextColor" );
		label.SetBinding( Label.FontFamilyProperty, "Font" );
		label.SetBinding( Label.FontSizeProperty, "FontSize" );

		Content = label;
	}
}

//
