﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using DXLib.UI.Layout;
using DXLib.UI.Control.Image;

namespace DXLib.UI.Control.List.Template;

/*
 * A DXListTemplate that contains an image together with title and subtitle text rows. Can be used as either a normal or
 * selected template.
 */
public class DXListImageTemplate : DXListTemplate
{
	/* Methods */
	public DXListImageTemplate( string icon, bool selected = false ) : base( selected )
	{
		BackgroundColor = selected ? SelectedColor : DeselectedColor;
		Padding = 0;

		// Layout
		DXGridLayout layout = new()
		{
			BackgroundColor = selected ? SelectedColor : DeselectedColor,

			RowSpacing = 0,
			ColumnSpacing = 5
		};

		// Image
		DXImageArea imageArea = new()
		{
			Color = DXColors.Action,
			IconColor = DXColors.Light4,

			Padding = 0
		};

		imageArea.SetSize( 40, 40, 0.80 );
		imageArea.SetIcon( icon );

		imageArea.SetBinding( DXImageArea.ImageUrlProperty, "ImageUrl" );

		// Label
		label.Font = DXFonts.RobotoBold;
		label.FontSize = 15;

		// Sublabel
		DXLabel subLabel = new()
		{
			Padding = new Thickness( 5, 0 ),

			BackgroundColor = selected ? SelectedColor : DeselectedColor,
			TextColor = DXColors.Dark3,

			Font = DXFonts.Roboto,
			FontSize = 12,

			VAlign = TextAlignment.Center,

			Horizontal = LayoutOptions.Fill,
			Vertical = LayoutOptions.Center
		};

		subLabel.SetBinding( Label.TextProperty, "SubValue" );

		// 2 rows
		layout.AddStarRow( 60 );				// 0: label
		layout.AddStarRow( 40 );				// 1: sublabel

		// 2 columns
		layout.AddFixedColumn( 40 );			// 0: image
		layout.AddStarColumn();					// 1: labels

		// Add components
		layout.Add( imageArea, 0, 0, 1, 2 );
		layout.Add( label, 1, 0 );
		layout.Add( subLabel, 1, 1 );

		Content = layout;
	}
}

//
