﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using DXLib.UI.Layout;
using DXLib.UI.Control.Image;

namespace DXLib.UI.Control.List.Template;

/*
 * A DXListTemplate that adds an icon to the left of the row label. Can be used as either a normal or selected template.
 */
public class DXListIconTemplate : DXListTemplate
{
	/* Methods */
	public DXListIconTemplate( string icon, bool selected = false ) : base( selected )
	{
		BackgroundColor = selected ? SelectedColor : DXColors.Light4;
		Padding = 0;

		// Layout
		DXHorizontalLayout layout = new()
		{
			BackgroundColor = selected ? SelectedColor : DXColors.Light4,

			Padding = 0,
			Spacing = 5
		};

		// Image
		DXImageArea imageArea = new()
		{
			Color = DXColors.Action,
			IconColor = DXColors.Light4,

			Padding = 0
		};

		imageArea.SetIcon( icon );
		imageArea.SetSize( 40, 40, 0.80 );

        imageArea.SetBinding( DXImageArea.ColorProperty, "IconColor" );

        // Label
        label.Font = DXFonts.Roboto;
		label.FontSize = 17;

		layout.Add( imageArea );
		layout.Add( label );

		Content = layout;
	}
}

//
