﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Data;

namespace DXLib.UI.Control.List;

/*
 * Extends DXListItem to add binding properties for visual display of an individual item in a DXListMenu.
 */
public class DXListMenuItem : DXItem
{
	/* Properties */

	// Overrides base value to support grouping
	public string ListValue { get => Value; set => SetValue( value ); }

	// Used for grouping
	public string Alpha { get; set; }

	// Used for chronological sorting
	public DateTimeOffset Date { get; set; }

	// Extended fields
	public string SubValue { get; set; }
	public string Icon { get; set; }
	public string ImageUrl { get; set; }

	// Styling
	public Thickness Padding { get; set; }

	public Color Color { get; set; }
	public Color TextColor { get; set; }
	public Color IconColor { get; set; }

	public string Font { get; set; }
	public double FontSize { get; set; }

	/* Methods */

	// Menu specific functionality for sorting/grouping
	private void SetValue( string value )
	{
		Value = value;

		Alpha = value[ ..1 ];
	}
}

//
