﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.UI.Control;

/*
 * Simple control for drawing a horizontal separator line.
 */
public class DXLine : BoxView
{
	/* Properties */
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }

	// Line weight
	public double Thickness { get => HeightRequest; set => HeightRequest = value; }
	
	// Width
	public double Length { get => WidthRequest; set => WidthRequest = value; }

	/* Inherited */
	
	// Color
	// CornerRadius
	
	/* Methods */
	public DXLine()
	{
		HorizontalOptions = LayoutOptions.Start;
		VerticalOptions = LayoutOptions.Start;

		// Defaults
		Thickness = 2;
		Color = DXColors.Dark2;
		CornerRadius = 0;
	}
}

//
