﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Utils;

namespace DXLib.UI.Control;

/*
 * A MAUI Label wrapper providing convenience functionality for using custom fonts.
 */
public class DXLabel : Label
{
	/* Properties */
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }

	// Alignment shorthand
	public TextAlignment HAlign { set => HorizontalTextAlignment = value; }
	public TextAlignment VAlign { set => VerticalTextAlignment = value; }

	// Android specific positioning
	public double AdjustY { set { if ( DXDevice.IsAndroid ) Margin = new Thickness( 0, value, 0, 0 ); } }

	// FontFamily shorthand
	public string Font { set => FontFamily = value; }
	
	// Grayed-out disabled state
	public bool IsDisabled { set => Opacity = value ? 0.3 : 1.0; }

	/* Inherited */
	
	// Text
	// TextColor
	
	/* Fields */
	private string ResourceProperty;
	private string FontResourceProperty;

	// Shorthand for assigning text from static string resource
	public string Resource { get => ResourceProperty; set { ResourceProperty = value; Text = DXString.Get( value ); } }

	// Assigns font based on platform specific custom font resource file
	public string FontResource { get => FontResourceProperty; set { FontResourceProperty = value; Font = value; } }

	/* Methods */
	public DXLabel()
	{
		// Defaults
		LineBreakMode = LineBreakMode.NoWrap;
	}

	/* Layout Utils */

	// Shorthand for setting dimensions
	public void SetSize( double wd, double ht )
	{
		WidthRequest = wd;
		HeightRequest = ht;
	}

	// Shorthand for setting margin
	public void SetMargin( double left, double top, double right, double bottom )
	{
		Margin = new Thickness( left, top, right, bottom );
	}

	// Shorthand for setting layout options
	public void SetPosition( LayoutOptions horizontal, LayoutOptions vertical )
	{
		Horizontal = horizontal;
		Vertical = vertical;
	}
}

//
