/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using CommunityToolkit.Maui.Behaviors;

namespace DXLib.UI.Control;

/*
 * Wrapper for MAUI Image used for simple SVG icons. Convenience methods are provided for color tinting and sizing.
 */
public class DXIcon : Microsoft.Maui.Controls.Image
{
	/* Properties */
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }

	// Local SVG file
	public string Resource { set => Source = value; }
	
	// Tint color
	public Color Color { set => SetIconColor( value ); }

	// Shorthand for square/circle sizing
	public double Size { set => SetSize( value ); }
	
	/* Inherited */
	
	// BackgroundColor
	
	/* Methods */
	public DXIcon()
	{
		Margin = 0;
		IsOpaque = false;
		
		BackgroundColor = DXColors.Transparent;
		Aspect = Aspect.AspectFit;
	}
	
	// Convenience method for setting size to specified square/circle dimension
	public void SetSize( double size )
	{
		WidthRequest = size;
		HeightRequest = size;
	}
	
	// Used internally to set tint color
	private void SetIconColor( Color color )
	{
		IconTintColorBehavior behavior = new IconTintColorBehavior
		{
			TintColor = color
		};

		Behaviors.Add( behavior );
	}
}

//
