﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.UI.Control;

/*
 * Simple wrapper for XF BoxView, typically used to draw solid color areas or to fill grid cells. Can also be used to
 * draw simple shapes.
 */ 
public class DXFill : BoxView
{
	/* Properties */

	// Shapes
	public double Square { set { WidthRequest = value; HeightRequest = value; } }
	public double Circle { set { Square = value; CornerRadius = (value / 2); } }

	// Shorthand
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }
	
	/* Inherited */
	
	// Color
}

//
