/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Maui.ColorPicker;

namespace DXLib.UI.Control;

/*
 * Implements a UI control for choosing a 32bit color. The control can be sized to a parent view as needed.  
 */
public class DXColorPicker : ColorPicker
{
	/* Events */
	public Action<Color> ColorPicked { get; set; }

	/* Properties */
	
	// Should white be included in color palette?
	public bool AllowWhite { set => SetSpectrum( value ); }
	
	/* Inherited */
	
	// PickedColor
	
	/* Methods */
	public DXColorPicker()
	{
		Padding = 0;
		Margin = 0;
		
		// Set defaults
		ColorFlowDirection = ColorFlowDirection.Horizontal;
		SetSpectrum( false );

		PointerRingDiameterUnits = 0.6;
		PointerRingBorderUnits = 0.3;
		
		// Register for events
		PickedColorChanged += OnPickedColorChanged;
	}

	// Sets currently selected picker color
	public void SetColor( Color color )
	{
		if ( color != null )
		{
			PickedColorChanged -= OnPickedColorChanged;

			// Do NOT trigger callback for internal selection
			PickedColor = color;

			PickedColorChanged += OnPickedColorChanged;
		}
	}
	
	// Sets available color spectrum (optionally excluding white)
	private void SetSpectrum( bool allowWhite )
	{
		ColorSpectrumStyle = allowWhite ? ColorSpectrumStyle.TintToHueToShadeStyle : ColorSpectrumStyle.HueToShadeStyle;
	}
	
	/* Event Callbacks */
	
	// User chose color from picker
	private void OnPickedColorChanged( object sender, PickedColorChangedEventArgs args )
	{
		ColorPicked?.Invoke( args.NewPickedColorValue );
	}
}

//
