/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Syncfusion.Maui.Buttons;

namespace DXLib.UI.Control.Button;

/*
 * Implements a simple on/off radio button. Button colors can be customized. By default, only the button itself is
 * implemented without accompanying text.
 */
public class DXRadioButton : SfRadioButton
{
	/* Constants */
	private static readonly Color DefaultOnColor = DXColors.Positive;
	private static readonly Color DefaultOffColor = DXColors.Dark3;

	/* Events */
	public Action<string> TurnedOn { get; set; }
	
	/* Properties */
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }
	
	// Unique ID within list
	public string Key { get; set; }

	// Current state
	public bool IsOn { get => IsChecked; set => IsChecked = value; }
	
	// Colors
	public Color OnColor { set => CheckedColor = value; }
	public Color OffColor { set => UncheckedColor = value; }

	// Dynamic sizing
	public double Size { set => ControlSize = value; }
	
	/* Methods */
	public DXRadioButton()
	{
		// Defaults
		OnColor = DefaultOnColor;
		OffColor = DefaultOffColor;
		
		StrokeThickness = 2;
		EnabledAnimation = true;

		// No text
		Text = string.Empty;

		// Register for events
		StateChanged += OnStateChanged;
	}

	/* Event Callbacks */
	
	// User tapped radio button
	private void OnStateChanged( object sender, StateChangedEventArgs args )
	{
		// Button turned on, callback listener
		if ( args.IsChecked.HasValue && args.IsChecked.Value )
		{
			TurnedOn?.Invoke( Key );
		}
	}
}

//
