﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.UI.Control.Button;

/*
 * A tappable button with numeric text.
 */
public class DXNumberButton : DXButton
{
	/* Properties */
	public int Number { set => SetNumber( value ); }

	// Pad leading zeroes '0X'
	public bool PadZero { get; set; }
	
	//  Button config
	public double NumberSize { set => FontSize = value; }
	public Color NumberColor { set => TextColor = value; }
	
	// Rounded rect or full circle?
	public bool IsCircle { get; set; } = true;

	// Shorthand for setting square button size
	public double Size { set => SetSize( value, IsCircle ); }

	/* Inherited */
	
	// Text
	// Font
	// ButtonColor
	
	/* Methods */
	public DXNumberButton()
	{
		// Defaults
		Font = DXFonts.Oswald;
	}

	// Internally sets text number with optional zero padding
	private void SetNumber( int value )
	{
		Text = PadZero ? value.ToString( "00" ) : value.ToString();
	}
}

//
