﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Gestures;
using DXLib.Utils;

namespace DXLib.UI.Control.Badge;

/*
 * A rectangular badge with a centered all-caps text label. Both the badge and label colors can be customized. 
 */ 
public class DXTextBadge : DXContentGestures
{
	/* Events */
	public Action Selected { get; set; }

	/* Properties */

	// Lowercase
	public string Text { set => textLbl.Text = value; }
	public string Resource { set => textLbl.Text = DXString.Get( value ); }

	// Uppercase
	public string TextUpper { set => textLbl.Text = value?.ToUpper()!; }
	public string ResourceUpper { set => textLbl.Text = DXString.GetUpper( value ); }

	public Color TextColor { get => textLbl.TextColor; set => textLbl.TextColor = value; }
	public string Font { set => textLbl.FontResource = value; }
	public double FontSize { set => textLbl.FontSize = value; }

	/* Fields */
	private readonly DXLabel textLbl;

	/* Methods */
	public DXTextBadge()
	{
 		Padding = new Thickness( 5, (DXDevice.IsIOS ? 3 : 1), 5, 1 );

		// Main content
		textLbl = new DXLabel
		{
			Font = DXFonts.RobotoBold,
			FontSize = 11,

			LineBreakMode = LineBreakMode.NoWrap,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		// Register for events
		Tapped += OnTapped;

		Content = textLbl;
	}

	// Adjusts text x,y position within badge
	public void Adjust( double x, double y )
	{
		textLbl.Margin = new Thickness( x, y, 0, 0 );
	}

	// Determines if specified point is within badge bounds
	public bool Contains( Point origin, Point pt )
	{
		Rect bounds = Bounds.Offset( origin );

		return bounds.Contains( pt );
	}

	/* Event Callbacks */

	// User tapped content area, callback listener
	private void OnTapped( object sender, MR.Gestures.TapEventArgs args )
	{
		Selected?.Invoke();
	}
}

//
