﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Layout;

namespace DXLib.UI.Control.Badge;

/*
 * Displays a rectangular badge typically used for object counts. An upper label will contain the numeric count, while a
 * lower label will display the object name.
 */
public class DXCounterBadge : DXVerticalLayout
{
	/* Properties */
	public new int Count { get => Convert.ToInt32( countLbl.Text ); set => countLbl.Text = value.ToString(); }
	public string Title { get => titleLbl.Text; set => titleLbl.Text = value.ToUpper(); }

	public bool IsSmall { set { countLbl.FontSize = value ? 20 : 24; titleLbl.FontSize = value ? 10 : 12; } }

	/* Fields */
	private readonly DXLabel countLbl;
	private readonly DXLabel titleLbl;

	/* Methods */
	public DXCounterBadge()
	{
		BackgroundColor = DXColors.Light2;

		Padding = new Thickness( 5, 0, 5, 5 );
		Spacing = 0;

		// Count
		countLbl = new DXLabel
		{
			TextColor = DXColors.Dark4,

			Font = DXFonts.Oswald,
			FontSize = 24,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		Add( countLbl );

		// Title
		titleLbl = new DXLabel
		{
			TextColor = DXColors.Dark4,

			Font = DXFonts.Roboto,
			FontSize = 12,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Start
		};

		Add( titleLbl );
	}
}

//
