﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Gestures;
using DXLib.Utils;

namespace DXLib.UI.Container;

/*
 * A simple wrapper for a ContentView.
 */ 
public class DXContent : ContentView
{
	/* Properties */
	public LayoutOptions Horizontal { set => HorizontalOptions = value; }
	public LayoutOptions Vertical { set => VerticalOptions = value; }

	public Color Color { get => color; set { color = value; BackgroundColor = value; } }

	// Optional associated data
	public object Data { get; set; }

	/* Fields */
	private Color color;
	
	// Bounds usable BEFORE layout
	public Rect LayoutBounds { get; private set; }

	/* Methods */

	// Determines if specified x,y point within content bounds
	public bool Contains( Point point )
	{
		return Bounds.Contains( point );
	}

	// Convenience method for setting dimensions
	public virtual void SetSize( double width, double height )
	{
		WidthRequest = width;
		HeightRequest = height;
	}
	
	// Convenience method for setting padding
	public void SetPadding( double left, double top, double right, double bottom )
	{
		Padding = new Thickness( left, top, right, bottom );	
	}
	
	// Convenience method for setting margin
	public void SetMargin( double left, double top, double right, double bottom )
	{
		Margin = new Thickness( left, top, right, bottom );	
	}
	
	/* Layout */

	// Sets bounds of this border within specified layout
	public void SetLayoutBounds( DXAbsoluteGestures layout, double x, double y, double wd, double ht )
	{
		LayoutBounds = new Rect( x, y, wd, ht );
		
		layout.SetBounds( this, LayoutBounds );	
	}

	// Allows special handling for device rotation
	public virtual void Rotate()
	{}

	// Forces layout for current device type/orientation
	public void UpdateLayout()
	{
		UpdateLayout( DXDevice.GetLayoutType() );
	}

	// Gives subclasses opportunity to make type/orientation specific changes
	public virtual void UpdateLayout( LayoutType type )
	{
		switch ( type )
		{
			case LayoutType.Landscape: Landscape(); break;
			case LayoutType.Portrait: Portrait(); break;

			case LayoutType.WideLandscape: WideLandscape(); break;
			case LayoutType.WidePortrait: WidePortrait(); break;

			case LayoutType.MobileLandscape: MobileLandscape(); break; 
			case LayoutType.MobilePortrait: MobilePortrait(); break;
			
			default: break; 
		}
	}

	// Layout changes specific to each possible size
	protected virtual void Landscape() {}
	protected virtual void Portrait() {}

	protected virtual void WideLandscape() {}
	protected virtual void WidePortrait() {}

	protected virtual void MobileLandscape() {}
	protected virtual void MobilePortrait() {}
}

//
