﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Control;
using DXLib.Utils;

namespace DXLib.UI.Card;

/*
 * A generic 'Add New' card that is used on all card pages to add a new object of the corresponding type.
 */
public class DXCardNew : DXCard
{
	/* Properties */
	public string Type { get => type; set { type = value; SetLabel(); } }
	public double CardHt { get; set; }

	// Override tap state opacity settings
	protected override double DefaultOpacity => 0.50;
	protected override double TapOpacity => 1.0;

	/* Fields */
	private string type;
	private readonly DXLabel newLbl;

	/* Methods */
	public DXCardNew()
	{
		IsNew = true;

		BackgroundColor = DXColors.Dark2;
		Opacity = 0.50;

		layout.RowSpacing = 5;

		// Content vertically centered across 2 rows
		layout.AddStarRow();
		layout.AddStarRow();

		// + icon
		DXIcon icon = new()
		{
			Resource = "add_circle",
			Color = DXColors.Dark4,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.End
		};

		icon.SetSize( 40 );
		
		layout.Add( icon, 0, 0 );

		// 'Add New Foo'
		newLbl = new DXLabel
		{
			TextColor = DXColors.Dark4,

			Font = DXFonts.RobotoBold,
			FontSize = 20,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Start
		};

		layout.Add( newLbl, 0, 1 );
	}

	// Create 'Add New Foo' label for specified object type
	private void SetLabel()
	{
		newLbl.Text = $"{DXString.Get( "card.new" )} {DXString.Get( $"{type}.singular" )}";
	}

	// Card height must match other cards on page
	public override double GetViewHt()
	{
		return CardHt;
	}
}

//
