﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using DXLib.UI.Layout;
using DXLib.UI.Control;

using DXLib.Utils;

namespace DXLib.UI.Card;

/*
 * Encapsulates multiple labels to be displayed on a DXCard. Allows label area to have different background color,
 * margins, etc versus rest of the card.
 */
public class DXCardLabels : DXVerticalLayout
{
	/* Properties */
	public string SuperTitle { set => SetSuperTitle( value ); }
	public string Title { set => TitleLbl.Text = value; }
	public string SubTitle { set => SubTitleLbl.Text = value; }

	// Fonts sizes
	public double SuperTitleSize { set => SuperTitleLbl.FontSize = value; }
	public double TitleSize { set => TitleLbl.FontSize = value; }
	public double SubTitleSize { set => SubTitleLbl.FontSize = value; }

	/* Fields */
	public DXLabel SuperTitleLbl { get; private set; }
	public DXLabel TitleLbl { get; private set; }
	public DXLabel SubTitleLbl { get; set; }

	/* Methods */
	public DXCardLabels()
	{
		bool ios = DXDevice.IsIOS;

		IsClippedToBounds = true;
		
		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;
		
		// Defaults can be overidden
		BackgroundColor = DXColors.Light2;

		Padding = new Thickness( 10, (ios ? 10 : 5), 5, 10 );
		Spacing = ios ? 5 : 1;

		// Title
		TitleLbl = new DXLabel
		{
			TextColor = DXColors.Dark1,

			Font = DXFonts.RobotoBold,
			FontSize = 28,

			LineBreakMode = LineBreakMode.TailTruncation
		};

		Add( TitleLbl );

		// Below title
		SubTitleLbl = new DXLabel
		{
			TextColor = DXColors.Dark4,

			Font = DXFonts.RobotoBold,
			FontSize = 14,

			LineBreakMode = LineBreakMode.TailTruncation
		};

		Add( SubTitleLbl );
	}

	// Sets optional text for line above main card title
	private void SetSuperTitle( string value )
	{
		// Lazily create
		if ( SuperTitleLbl == null )
		{
			AddSuperTitle();
		}

		SuperTitleLbl!.Text = value?.ToUpper()!;
	}

	// Lazily create, required for proper spacing on Android when not used
	private void AddSuperTitle()
	{
		Spacing = 3;

		// Above title
		SuperTitleLbl = new DXLabel
		{
			TextColor = DXColors.Dark4,

			FontSize = 12,
			Font = DXFonts.Roboto,

			LineBreakMode = LineBreakMode.TailTruncation
		};

		Insert( 0, SuperTitleLbl );
	}
}

//
