﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.Log;

/*
 * Used to serialize an individual log entry, which represents either an error message or exception with stack trace.
 */
public class DXLogEntry
{
	/* Properties */
	public DateTimeOffset Timestamp { get; set; }
	public string Key { get; set; }

	// Error 
	public string Error { get; set; }
	public int Code { get; set; }

	// Exception
	public string Type { get; set; }
	public string Message { get; set; }
	public string Stack { get; set; }

	/* Methods */
	
	// Key only entry
	public DXLogEntry( string key )
	{
		Timestamp = DateTimeOffset.Now;
		
		Key = key;
	}
	
	// Error message based entry
	public DXLogEntry( string key, string error )
	{
		Timestamp = DateTimeOffset.Now;
		
		Key = key;
		Error = error;
	}
	
	// Exception based entry
	public DXLogEntry( string key, Exception ex, int code = DXLog.CodeNA )
	{
		Timestamp = DateTimeOffset.Now;
		
		Key = key;
		Code = code;
		
		// Exception
		if ( ex != null )
		{
			Type = ex.GetType().ToString();
			Message = ex.Message;
			Stack = ex.StackTrace;
		}
	}
}

//
