﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.Email;

/*
 * Used to configure email sends via local app or remove server (SendGrid).
 */
public class DXEmailConfig
{
	/* Properties */

	// Local/cloud send mode
	public bool IsLocal { get; set; }

	// From:
	public string FromAddress { get; set; }
	public string FromName { get; set; }

	// To: (single)
	public string ToAddress { get; set; }
	public string ToName { get; set; }

	// To: (group)
	public List<string> ToAddresses { get; set; }
	public List<string> ToNames { get; set; }

	public bool IsGroup => (ToAddresses != null);

	// Local only
	public string Subject { get; set; }
	public string Body { get; set; }

	// Dynamic template
	public string TemplateId { get; set; }
	public object TemplateData { get; set; }

	// File attachment
	public byte[] FileRaw { get; set; }			// Raw attachment data

	public string FileName { get; set; }		// Attachment filename
	public string FileData { get; set; }		// Raw data as Base64 string
	public string FileType { get; set; }        // Content type

	public bool HasAttachment => (FileName != null);
}

//
