﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace DXLib.Data;

/*
 * Simple container representing a dictionary key-value pair.
 */
public class DXItem
{
	/* Properties */
	public string Key { get; set; }
	public string Value { get; set; }

	// Optional 0-based index in list
	public int Index { get; set; }

	// Optional additional data
	public object Data { get; set; }

	/* Methods */
	public DXItem()
	{}
	
	// Convenience constructor for setting key/value
	public DXItem( string key, string value )
	{
		Key = key;
		Value = value;
	}
	
	// Tests equality based on key
	public override bool Equals( object obj )
	{
		return (obj is DXItem item) && item.Key.Equals( Key );
	}

	// Generates unique hash code, required for list de-duping
	public override int GetHashCode()
	{
		return Key.GetHashCode();
	}

	// Returns specified list with duplicate values removed
	public static List<DXItem> DistinctByValue( List<DXItem> items )
	{
		List<DXItem> distinct = [];

		foreach ( DXItem item in items.Where( item => !Contains( distinct, item.Value ) ) )
		{
			distinct.Add( item );
		}

		return distinct;
	}

	// Determines if specified list of key-values contains given value
	private static bool Contains( List<DXItem> items, string value )
	{
		return items.Any( item => (item.Value != null) && (item.Value == value) );
	}
}

//
