﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Plugin.InAppBilling;

using DXLib.Utils;

namespace DXLib.Billing;

/*
 * Simple wrapper for a billing library purchase object. Provides abstraction from library and platform specific implementation.
 */
public class DXBillingPurchase
{
	/* Properties */
	public string Platform { get; private set; }

	public string ProductId { get; private set; }
	public string PurchaseId { get; private set; }

	public string Token { get; private set; }
	public string Payload { get; private set; }

	/* Methods */

	// Instantiates a new product from specified raw library object
	public DXBillingPurchase( InAppBillingPurchase purchase )
	{
		Platform = DXDevice.PlatformOSKey;

		// Purchase info
		if ( purchase != null )
		{
			ProductId = purchase.ProductId;
			PurchaseId = purchase.Id;

			Token = purchase.PurchaseToken;
			Payload = purchase.Payload;
		}
	}
}

//
