﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Globalization;

using Plugin.InAppBilling;

namespace DXLib.Billing;

/*
 * Simple wrapper for a billing library product object. Provides abstraction from library and platform specific implementation.
 */
public class DXBillingProduct
{
	/* Properties */
	public string ProductId { get; set; }

	public string Name { get; set; }
	public string Description { get; set; }

	public string LocalizedPrice { get; set; }
	public string CurrencyCode { get; set; }

	// Do NOT need Apple or Android Extras
	
	/* Methods */

	// For internal debug only
	public DXBillingProduct()
	{}

	// Instantiates a new product from specified raw library object
	public DXBillingProduct( InAppBillingProduct product )
	{
		ProductId = product.ProductId;

		Name = product.Name;
		Description = product.Description;

		LocalizedPrice = product.LocalizedPrice;
		CurrencyCode = product.CurrencyCode;
	}

	// Returns numeric price for specified product
	public static double GetPrice( string productId, List<DXBillingProduct> products )
	{
		// Must use cached products
		foreach ( DXBillingProduct product in products )
		{
			if ( product.ProductId == productId )
			{
				// Must parse as formatted currency
				try
				{
					return double.Parse( product.LocalizedPrice, NumberStyles.Currency );
				}
				catch
				{
					return 0;
				}
			}
		}

		// 0 indicates error
		return 0;
	}
}

//
