﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Layout;
using DXLib.UI.Container;

namespace iStatVball3;

/*
 * Base class for all drawers launched from the ToolBar including Settings, Help, and Account. Supports advancing to a
 * second content view within the drawer and then returning to the first view.
 */
public abstract class ToolBarDrawer : DXGridLayout
{
	/* Events */
	public Action Closed { get; set; }
	
	/* Fields */
	
	// Parent drawer
	protected readonly DXDrawer drawer;
	
	// Support multiple views
	private bool firstView;
	
	/* Methods */
	protected ToolBarDrawer( DXDrawer drawer )
	{
		this.drawer = drawer;

		IgnoreSafeArea = true;
		BackgroundColor = DXDrawer.FillColor;
		
		Padding = 0;
		Margin = 0;
		
		drawer.SetCallback( OnDismissed );

		firstView = true;
	}

	// Shows drawer (first view only)
	public void Show()
	{
		if ( firstView )
		{
			drawer.Show();
		}
	}
	
	// Closes drawer (first view only)
	public void Hide()
	{
		if ( firstView )
		{
			drawer.Hide();

			Shell.Instance.ToolBar.Reset();
		}
	}
	
	// Advances to specified second view
	public void Next( string title, View view, Action callback )
	{
		firstView = false;
		
		drawer.Next( title, view, callback );
	}	
	
	// Returns to previous (first) view
	public void Previous()
	{
		firstView = true;
		
		drawer.Previous();
	}

	/* Event Callbacks */
	
	// User tapped close/back button
	private void OnDismissed()
	{
		Closed?.Invoke();
	}
}

//
