﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Plugin.StoreReview;

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Container;

using DXLib.UI.Control;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * Displays a modal popup to gauge sentiment of the user before requesting an app review. Positive sentiment is directed
 * to the native review prompt. Negative sentiment is directed to a feedback form.
 */
public class ReviewPrompt : DXGridLayout
{
	/* Fields */
	private DXPopup popup;

	/* Methods */
	public ReviewPrompt()
	{
		BackgroundColor = DXColors.Light4;

		Padding = new Thickness( 20, 15, 20, 10 );
		RowSpacing = 15;
		ColumnSpacing = 0;

		const double iconSize = 30;
		const double fontSize = 20;
		
		// 'Are you enjoying iStatVball 3?'
		DXLabel titleLbl = new()
		{
			Resource = "review.title",
			TextColor = DXColors.Dark1,

			Font = DXFonts.RobotoBold,
			FontSize = fontSize,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Start
		};

		// Happy face
		DXIconButton positiveIcn = new()
		{
			Resource = "sentiment_happy",
			IconColor = DXColors.Positive,
			Size = iconSize,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,

			ButtonTapped = OnPositiveTapped
		};

		positiveIcn.Init();
		
		// 'Yes, love it!'
		DXTextButton positiveLbl = new()
		{
			Resource = "review.positive",
			TextColor = DXColors.Dark3,

			Font = DXFonts.RobotoBold,
			FontSize = fontSize,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,

			ButtonTapped = OnPositiveTapped
		};

		// Sad face
		DXIconButton negativeIcn = new()
		{
			Resource = "sentiment_sad",
			IconColor = DXColors.Negative,
			Size = iconSize,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,

			ButtonTapped = OnNegativeTapped
		};

		negativeIcn.Init();
		
		// 'Not so much'
		DXTextButton negativeLbl = new()
		{
			Resource = "review.negative",
			TextColor = DXColors.Dark3,

			Font = DXFonts.RobotoBold,
			FontSize = fontSize,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,

			ButtonTapped = OnNegativeTapped
		};

		// 'Ask me later'
		DXTextButton laterLbl = new()
		{
			Resource = "review.later",
			TextColor = DXColors.Dark4,

			Font = DXFonts.Roboto,
			FontSize = (fontSize - 3),

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.End,

			ButtonTapped = OnLaterTapped
		};

		// 2 columns
		AddFixedColumn( 40 );		// 0: icon
		AddStarColumn();			// 1: label

		// 4 rows
		AddFixedRow( 30 );			// 0: title
		AddFixedRow( 30 );			// 1: positive
		AddFixedRow( 30 );			// 2: negative
		AddStarRow();				// 3: later

		// Add components
		Add( titleLbl, 0, 0, 2, 1 );

		Add( positiveIcn, 0, 1 );
		Add( positiveLbl, 1, 1 );

		Add( negativeIcn, 0, 2 );
		Add( negativeLbl, 1, 2 );

		Add( laterLbl, 0, 3, 2, 1 );
	}

	// Displays sentiment form in modal popup
	public void Show()
	{
		popup = new DXPopup( this )
		{
			IsModal = true,

			ViewWidth = 315,
			ViewHeight = 185
		};

		popup.Show();
	}

	/* Event Callbacks */

	// User tapped positive sentiment, request review
	private void OnPositiveTapped()
	{
		OnPositiveTapped( null );
	}
	private async void OnPositiveTapped( object data )
	{
		await CrossStoreReview.Current.RequestReview( false );

		popup.Hide();

		// User will not be asked again
		await Shell.CurrentUser.UpdateReviewed();
	}

	// User tapped negative sentiment, show feedback form
	private void OnNegativeTapped()
	{
		OnNegativeTapped( null );
	}
	private void OnNegativeTapped( object data )
	{
		ReviewFeedback feedback = [];
		feedback.Show();

		popup.Hide();
	}

	// User tapped 'ask me later', dismiss popup
	private void OnLaterTapped( object data )
	{
		popup.Hide();
	}
}

//
