﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using CommunityToolkit.Mvvm.Messaging;

using DXLib.UI.Container;
using DXLib.UI.Form.Message;

namespace iStatVball3;

/*
 * Base class for all launch related UI pages.
 */
public abstract class LaunchPage : DXScroll
{
	/* Constants */
	public const double BasePad = 15;
	
	// Starts listening for data field changes
	public void Start()
	{
		WeakReferenceMessenger.Default.Register<DXFormChangedMessage>( this, OnControlChanged );
	}

	// Unsubscribes from messages when leaving page (not required)
	public void Stop()
	{
		WeakReferenceMessenger.Default.UnregisterAll( this );
	}

	// Resets all page/button state 
	public virtual void Reset()
	{}

	/* Event Callbacks */
	
	// Called back when any control on page changes value
	protected virtual void OnControlChanged( object sender, DXFormChangedMessage msg )
	{}
}

//