﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;

using DXLib.UI.Form;
using DXLib.UI.Form.Control;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Displays data entry form centered within login screen. All fields are required.
 */
public class LaunchLoginForm : DXGridLayout
{
	/* Properties */
	public string Username { get => username.Text; set => username.Text = value; }
	public string Password => password.Text;

	/* Fields */

	// List 1
	private readonly DXTextField username;
	private readonly DXTextField password;

	/* Methods */
	public LaunchLoginForm()
	{
		BackgroundColor = DXColors.Light4;

		// Spacing
		RowSpacing = 16;
		ColumnSpacing = 40;

		/* List 1 */
		DXVerticalLayout innerLayout = new()
		{
			Spacing = 16
		};

		// Username
		username = new DXTextField
		{
			Key = "username",
			Title = "login.email",
			Text = null,
			MinLength = 3,
			MaxLength = 64,
			Type = DXTextField.TextType.Email,
			Hint = DXFormControl.HintType.Email,
			Help = "login.user",
		};

		Add( innerLayout, username );

		// Password
		password = new DXTextField
		{
			Key = "password",
			Title = "login.password",
			Text = null,
			MinLength = 1,
			MaxLength = 64,
			Type = DXTextField.TextType.Password,
			Hint = DXFormControl.HintType.None,
			Help = "login.pswd"
		};

		Add( innerLayout, password );
		Add( innerLayout, 0, 0 );
	}

	// Used internally to configure controls being added to form
	private static void Add( DXVerticalLayout list, DXTextField control )
	{
		control.IsRequired = true;
		control.SetState( DXFormControl.ControlState.Normal );
		control.Init();

		list.Add( control );
	}

	// Determines if all data on form is valid
	public bool IsValid()
	{
		return username.IsValid() && password.IsValid();
	}

	// Hides native keyboard
	public async Task HideKeyboard()
	{
		await username.HideKeyboard();
		await password.HideKeyboard();
	}
	
	/* Layout */

	// Device/orientation specific layout
	public override void UpdateLayout( LayoutType type )
	{
		// Default sizing
		Padding = 36;

		// Size specific layout
		base.UpdateLayout( type );
	}

	// Mobile portrait
	protected override void MobilePortrait()
	{
		Padding = new Thickness( 20, 32 );
	}
}

//
