﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Container;

using DXLib.UI.Control;
using DXLib.UI.Control.Button;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Layout for the settings drawer footer, which includes a version info label as well as an about popup link.
 */ 
public class SettingsFooter : DXGridLayout
{
	/* Fields */
	private readonly DXIconButton aboutIcon;
	private readonly DXTextButton aboutLink;

	/* Methods */
	public SettingsFooter()
	{
		IgnoreSafeArea = true;
		BackgroundColor = DXDrawer.FillColor;

		double safeBottom = DXDevice.SafeArea().Bottom;
		
		// Spacing
		Padding = (safeBottom > 0) ? new Thickness( 15, 15, 15, safeBottom ) : new Thickness( 15, 10, 15, 10 );
		Margin = 0;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;

		RowSpacing = 0;
		ColumnSpacing = 8;
		
		const double iconSize = 26;
		
		// Icon
		aboutIcon = new DXIconButton
		{
			Resource = "info",
			
			IconColor = DXColors.Action,
			Size = iconSize,
			
			Margin = 0,
			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,

			IsSticky = true,
			ButtonTapped = OnAboutTapped
		};

		aboutIcon.Init();
		
		AddFixedColumn( iconSize );
		Add( aboutIcon, 0, 0 );

		// Link
		aboutLink = new DXTextButton
		{
			Resource = "settings.about",

			Color = DXColors.Action,
			Font = DXFonts.Roboto,
			FontSize = 16,

			Margin = 0,
			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center,
			
			IsSticky = true,
			ButtonTapped = OnAboutTapped
		};

		AddAutoColumn();
		Add( aboutLink, 1, 0 );

		// 'major.minor.micro'
		string versionStr = DXString.Get( "settings.version" );
		const string numberStr = App.AppVersion;

		// Version
		DXLabel versionLbl = new()
		{
			Text = $"{versionStr} {numberStr}",
			TextColor = DXColors.Dark4,

			Font = DXFonts.Roboto,
			FontSize = 14,

			Margin = 0,
			VAlign = TextAlignment.Center,

			Horizontal = LayoutOptions.End,
			Vertical = LayoutOptions.Center
		};

		AddStarColumn();
		Add( versionLbl, 2, 0 );
	}

	/* Event Callbacks */

	// Show popup attached to icon
	private void OnAboutTapped()
	{
		DXPopup popup = new( "settings.about", new SettingsAbout() )
		{
			ViewWidth = SettingsAbout.ViewWd,
			ViewHeight = SettingsAbout.ViewHt,
			
			PopupClosed = OnAboutClosed
		};

		popup.ShowFromView( aboutIcon );
	}

	// Link tap same behavior as icon
	private void OnAboutTapped( object data )
	{
		OnAboutTapped();
	}

	/* Event Callbacks */

	// Reset sticky button state
	private void OnAboutClosed()
	{
		aboutIcon.Reset();
		aboutLink.Reset();
	}
}

//
