﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Container;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Implements UI for the Settings toolbar drawer, which displays grouped lists of user settings for the app. The bottom
 * of the drawer displays about and version info.
 */
public class SettingsDrawer : ToolBarDrawer
{
	/* Methods */
	public SettingsDrawer( DXDrawer drawer ) : base( drawer )
	{
		// Main content
		SettingsContent content = new SettingsContent( this );

		AddStarRow();
		Add( content, 0, 0 );

		// About/Version footer
		SettingsFooter footer = [];

		double footerHt = (56 + DXDevice.SafeArea().Bottom);
		
		AddFixedRow( footerHt );
		Add( footer, 0, 1 );
	}
}

//
