﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * Content for the app About popup launched from the settings drawer footer.
 */ 
public class SettingsAbout : DXVerticalLayout
{
	/* Constants */
	public const double ViewWd = 320;
	public const double ViewHt = 250;
	
	/* Methods */
	public SettingsAbout()
	{
		// Layout
		BackgroundColor = DXColors.Light4;

		Padding = 20;
		Spacing = 20;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Center;

		// Credits, Legal, Thanks
		Add( CreateLabel( "about.credits" ) );
		Add( CreateLabel( "about.legal" ) );
		Add( CreateLabel( "about.thanks" ) );
	}

	// Creates all labels same size, color, word wrapping, centered
	private static DXLabel CreateLabel( string resource )
	{
		return new DXLabel
		{
			Resource = resource,

			TextColor = DXColors.Dark1,
			Font = DXFonts.Roboto,
			FontSize = 14,

			LineBreakMode = LineBreakMode.WordWrap,
			HAlign = TextAlignment.Center,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};
	}
}

//
